<?php

namespace Modules\Blog\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\Relationship\StatusRelationTrait;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Career extends Model
{
    use HasFactory, StatusRelationTrait, SoftDeletes;

    protected $fillable = [
        'name',
        'title',
        'image',
        'overview',
        'eligibility',
        'job_roles',
        'salary',
        'career_opportunity',
        'top_colleges',
    ];

    // image relation with upload
    public function imageDetail():BelongsTo
    {
        return $this->belongsTo('App\Models\Upload', 'image');
    }

}
