<?php

namespace Modules\Blog\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Contracts\Support\Renderable;
use Modules\Blog\Interfaces\CareerInterface;
use Modules\Blog\Http\Requests\CreateCareerRequest;
use Modules\Blog\Http\Requests\UpdateCareerRequest;

class CareerController extends Controller
{
    // constructor injection
    protected $career;

    public function __construct(CareerInterface $career)
    {
        $this->career         = $career;
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {
        try {

            $data['tableHeader']    = $this->career->tableHeader(); // table header
            $data['careers']          = $this->career->getAll($request); // data
            $data['title']          = "Careers";

            // dd($data);
            if ($data['careers']) {
                return view('blog::career.index', compact('data')); // view
            }

            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }

        catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {

        try {
            $data['title']              =   'Create Career';
            $data['button']             =   ___('common.create');
            return view('blog::career.create', compact('data'));
        } catch (\Throwable $th) {

            return redirect()->route('career.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(CreateCareerRequest $request)
    {
        try {
            $result = $this->career->store($request);
            // dd($result);
            if ($result->original['result']) {
                return redirect()->route('career.index')->with('success', $result->original['message']);
            } else {
                return redirect()->route('career.index')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            // dd($th);
            return redirect()->route('career.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('blog::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        try {
            $data['title']              = 'Edit Career'; // title
            $data['button']             = ___('common.update'); // button
            $data['career']               = $this->career->model()->find($id);
// dd($data['career']->image);
            return view('blog::career.edit', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->route('career.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(UpdateCareerRequest $request, $id)
    {
        try {
            $result = $this->career->update($request, $id);
            if ($result->original['result']) {
                return redirect()->route('career.index')->with('success', $result->original['message']);
            } else {
                return redirect()->route('career.index')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->route('career.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        try {
            $result = $this->career->destroy($id);
            if ($result->original['result']) {
                return redirect()->route('career.index')->with('success', $result->original['message']);
            } else {
                return redirect()->route('career.index')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->route('career.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }
}
