<?php

namespace Modules\CMS\Entities;

use App\Models\Upload;
use App\Traits\Relationship\StatusRelationTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory, StatusRelationTrait;

    protected $fillable = [
        'name','duration_type','price','duration','status_id' // Add any other fillable attributes here
    ];

    // booted
    protected static function booted()
    {
        static::created(function ($subscriptions) { // when subscriptions created then forget cache
            cache()->forget('subscriptions');
        });

        static::updated(function ($subscriptions) { // when subscriptions updated then forget cache
            cache()->forget('subscriptions');
        });

        static::deleted(function ($subscriptions) { // when subscriptions deleted then forget cache
            cache()->forget('subscriptions');
        });


    }

    public function scopeSearch($query, $request)
    {
        if ($request->has('search') && !empty($request->search)) {
            $query->where('name', 'like', '%' . $request->search . '%');
        }
        return $query;
    }

   

    public function features()
    {
        return $this->hasMany('Modules\CMS\Entities\SubscriptionFeature');
    }

    public function scopeActive($query)
    {
        return $query->where('status_id', 1);
    }
}
