<?php

namespace Modules\CMS\Http\Controllers;

use App\Traits\ApiReturnFormatTrait;
use GrahamCampbell\ResultType\Success;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\CMS\Entities\Subscription;
use Modules\CMS\Entities\SubscriptionFeature;
use Modules\CMS\Http\Requests\SubscriptionRequest;
use Modules\CMS\Http\Requests\UpdateSubscriptionRequest;
use Modules\CMS\Interfaces\SubscriptionInterface;

class SubscriptionController extends Controller
{
    use ApiReturnFormatTrait;

    protected $subscription;

    public function __construct(SubscriptionInterface $subscriptionInterface)
    {
        $this->subscription = $subscriptionInterface;
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {
        try {
            $data['subscriptions'] = $this->subscription->model()->search($request)->paginate($request->show ?? 10); // data
            $data['title'] = ___('common.Subscription List'); // title
            return view('cms::subscription.index', compact('data')); // view
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        try {
            $data['title'] = ___('common.Create Subscription Plan'); // title
            $data['button'] = ___('common.Create'); // button
            return view('cms::subscription.create', compact('data')); // view
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(SubscriptionRequest $request)
    {
        // try {
        // dd($request->all())
        $plan = Subscription::create([
            'name' => $request->name,
            'price' => $request->price,
            'duration_type' => $request->duration_type,
            'duration' => $request->duration,
            'status_id' => $request->status_id,
        ]);

        // dd($plan);
        // Create the features
        foreach ($request->features as $key => $featureName) {
            // dd($request->values[$key]);
            $feature = SubscriptionFeature::create([
                'name' => $featureName,
                'value' => $request->values[$key],
                'subscription_id' => $plan->id,
            ]);
        }
        return redirect()->route('admin.subscription.index')->with('success', 'Successfully created');
        // } else {
        //     return redirect()->back()->with('danger', $result->original['message']);
        // }
        // } catch (\Throwable $th) {
        //     return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        // }
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        try {
            $data['subscription'] = $this->subscription->model()->findOrFail($id);
            if (!$data['subscription']) {
                return redirect()->back()->with('danger', ___('alert.subscription_not_found'));
            }
            $data['title'] = ___('common.Edit Subscription'); // title
            $data['button'] = ___('common.Update'); // button
            return view('cms::subscription.edit', compact('data')); // view
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(UpdateSubscriptionRequest $request, $id)
    {
        try {

            $plan = Subscription::find($id);
            $plan->name = $request->name;
            $plan->price = $request->price;
            $plan->duration = $request->duration;
            $plan->duration_type = $request->duration_type;
            $plan->status_id = $request->status_id;
            $plan->save();

            SubscriptionFeature::where('subscription_id', $id)->delete();


            foreach ($request->features as $key => $featureName) {
                // dd($request->values[$key]);
                $feature = SubscriptionFeature::create([
                    'name' => $featureName,
                    'value' => $request->values[$key],
                    'subscription_id' => $plan->id,
                ]);
            }

            return redirect()->route('admin.subscription.index')->with('success', 'Successfully Update');
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        try {
            $result = $this->subscription->destroy($id);
            if ($result->original['result']) {
                return redirect()->back()->with('success', $result->original['message']);
            } else {
                return redirect()->back()->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }
}
