<?php

namespace Modules\Instructor\Http\Requests;

use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Http\FormRequest;

class BankRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'bank_name' => 'required|max:255',
            'account_number' => 'required',
            'ifsc_code' => 'required',
            'account_holder_name' => 'required',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [
            'bank_name.required' => 'Bank name is required',
            'account_number.required' => 'Account number is required',
            'ifsc_code.required' => 'IFSC code is required',
            'account_holder_name.required' => 'Account holder name is required',
        ];
    }
}
