@extends('panel.instructor.layouts.master')
@section('title')
{{ @$data['title'] }}
@endsection


@section('content')
<div class="page-content">

    {{-- breadecrumb Area S t a r t --}}
    @include('backend.ui-components.breadcrumb', [
    'title' => @$data['title'],
    'routes' => [
    route('dashboard') => ___('common.Dashboard'),
    '#' => @$data['title'],
    ],

    'buttons' => 1,
    ])
    {{-- breadecrumb Area E n d --}}

    <!--  table content start -->
    <div class="table-content table-basic ecommerce-components product-list">
        <div class="card">
            <div class="card-body">
                <!--  toolbar table start  -->
                <div
                    class="table-toolbar d-flex flex-wrap gap-2 flex-column flex-xl-row justify-content-center justify-content-xxl-between align-content-center pb-3">
                    <form action="" method="get">
                        <div class="align-self-center">
                            <div
                                class="d-flex flex-wrap gap-2 flex-column flex-lg-row justify-content-center align-content-center">
                                <!-- show per page -->
                                @include('backend.ui-components.per-page')
                                <!-- show per page end -->

                                <div class="align-self-center d-flex gap-2">
                                    <!-- search start -->
                                    <div class="align-self-center">
                                        <div class="search-box d-flex">
                                            <input class="form-control" placeholder="{{ ___('common.search') }}"
                                                name="search" value="{{ @request()->search }}" />
                                            <span class="icon"><i class="fa-solid fa-magnifying-glass"></i></span>
                                        </div>
                                    </div>
                                    <!-- search end -->


                                    <!-- dropdown action -->
                                    <div class="align-self-center">
                                        <div class="dropdown dropdown-action">
                                            <button type="submit" class="btn-add">
                                                <span class="icon">{{ ___('common.Filter') }}</span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>


                    <!-- add btn start -->

                    <div class="align-self-center d-flex gap-2">
                        <!-- add btn -->
                        <div class="align-self-center">
                            <a href="{{ route('instructor.slider.create') }}" role="button" class="btn-primary btn"
                                data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Add">
                                <span><i class="fa-solid fa-plus"></i> </span>
                                <span class="d-none d-xl-inline">{{ ___('common.add') }}</span>
                            </a>
                        </div>
                    </div>

                    <!-- add btn end -->
                </div>
                <!--toolbar table end -->
                <!--  table start -->
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead class="thead">
                            <!-- start table header from ui-helper function -->
                            {{ table_header('', $data['tableHeader']) }}
                            <!-- end table header from ui-helper function -->
                        </thead>
                        <tbody class="tbody">

                            @forelse ($data['sliders'] as $key => $slider)
                            <tr>
                                <td>{{ @$slider->id }}</td>
                                <td>{{ Str::limit(@$slider->title, 20) }}</td>
                                <td>{{ Str::limit(@$slider->sub_title, 20) }}</td>
                                <td>
                                    <img src="{{ showImage(@$slider->iconImage->paths['400x1260'], 'default-1.jpeg') }}"
                                        alt="{{ @$slider->title }}" width="35px">
                                </td>
                                <td>
                                    {{ statusBackend(@$slider->status->class, $slider->status->name) }}
                                </td>
                                <td>{{ @$slider->serial }}</td>
                                <td class="create-date">{{ showDate(@$slider->created_at) }}</td>

                                <td class="action">






                                    <a href="{{ route('instructor.slider.edit', $slider->id) }}" class="btn btn-primary btn-sm">Edit</a>
                                    <form action="{{ route('instructor.slider.destroy', $slider->id) }}" method="POST" style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this item?');">Delete</button>
                                    </form>




                                </td>
                            </tr>
                            @empty
                            <!-- empty table -->
                            @include('backend.ui-components.empty_table', [
                            'colspan' => '8',
                            'message' => ___(
                            'message.Please add a new entity or manage the data table to see the content here'),
                            ])
                            <!-- empty table -->
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <!--  table end -->
                <!--  pagination start -->
                @include('backend.ui-components.pagination', ['data' => $data['sliders']])
                <!--  pagination end -->
            </div>
        </div>
    </div>
    <!--  table content end -->
</div>
@endsection
@push('script')
@include('backend.partials.delete-ajax')
@endpush