<?php

namespace Modules\Organization\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrgQuestionAnswer extends Model
{
    use HasFactory;

    protected $table = 'org_question_answer';

    protected $fillable = [
        'org_id',
        'question',
        'answer'
    ];

    public function organization()
    {
        return $this->belongsTo(Organization::class, 'org_id');
    }
}