<?php

namespace Modules\Organization\Http\Controllers;

use App\Models\Inquiry;
use Illuminate\Contracts\Support\Renderable;
use App\Traits\ApiReturnFormatTrait;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Organization\Http\Requests\CollageinfoRequest;
use Modules\Organization\Http\Requests\CollageinfoLinksRequest;
use Modules\Organization\Http\Requests\PlacementLinksRequest;
use Modules\Organization\Http\Requests\CampusLinksRequest;
use Modules\Organization\Http\Requests\SkillRequest;
use Modules\Organization\Http\Requests\CourseRequest;
use Modules\Organization\Http\Requests\ScholarshipRequest;
use Modules\Organization\Http\Requests\AdmissionRequest;
use Modules\Organization\Http\Requests\PlacementRequest;
use Modules\Organization\Http\Requests\ReviewRequest;
use Modules\Organization\Http\Requests\CampusRequest;
use Modules\Organization\Http\Requests\GalleryRequest;
use Modules\Organization\Http\Requests\AdminOrganizationRequest;
use Modules\Organization\Http\Requests\AdmissionLinksRequest;
use Modules\Organization\Http\Requests\LinkRequest;
use Modules\Organization\Http\Requests\OrganizationCreate;
use Modules\Organization\Interfaces\OrganizationInterface;
use Modules\Organization\Entities\OrgQuestionAnswer;

class OrganizationController extends Controller
{
    use ApiReturnFormatTrait;

    // constructor injection
    protected $organization;

    public function __construct(OrganizationInterface $organizationInterface)
    {
        $this->organization = $organizationInterface;
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {
        try {
            $data['organizations'] = $this->organization->model()->active()->search($request)->paginate($request->show ?? 10); // data
            $data['title'] = ___('organization.Organization List'); // title
            return view('organization::panel.organization.index', compact('data')); // view
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    //organization inquires
    public function inquiries(Request $request)
    {
        // try {
            if ($request->search) {
                $search = $request->search;
                $data['inquiries'] = Inquiry::where('name', 'like', '%' . $search . '%')->orWhere('email', 'like', '%' . $search . '%')->orWhere('phone', 'like', '%' . $search . '%')->latest()->paginate(10);
            } else {
                $data['inquiries'] = Inquiry::latest()->paginate(10);
            }
            $data['title'] = ___('organization.Organization Inquires List'); // title
            return view('organization::inquires', compact('data')); // view
        // } catch (\Throwable $th) {
        //     return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        // }
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        try {
            $data['title'] = ___('organization.Create Organization'); // title
            return view('organization::panel.organization.create', compact('data')); // view
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(OrganizationCreate $request)
    {
        try {
            $result = $this->organization->create($request);
            if ($result->original['result']) {
                return redirect()->route('organization.admin.index')->with('success', $result->original['message']);
            } else {
                return redirect()->back()->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('organization::show');
    }

    public function details($slug)
    {
        // try {
        $data['title'] = ___('frontend.Course Details'); // title
        $data['course'] = $this->course->model()->slug($slug)->first();
        if ($data['course']->user->role_id == Role::INSTRUCTOR) {
            $data['user_type'] = ___('frontend.Instructor');
            $data['profile'] = view('frontend.partials.course.instructor_profile', compact('data'))->render();
        } else {
            $data['user_type'] = ___('frontend.Organization');
            $data['instructors'] = $this->instructorCommissionInterface->model()->where('course_id', $data['course']->id)->get();
            $data['profile'] = view('organization::panel.organization.frontend.partials.organization_profile', compact('data'))->render();
        }
        $data['review'] = view('frontend.partials.course.reviews', compact('data'))->render();
        $data['curriculum'] = view('frontend.partials.course.curriculum', ['sections' => $data['course']->sections])->render();

        if ($data['course']) {
            // package course
            if (module('Subscription') && setting('subscription_setup')) {
                $packageCourseRepository = new \Modules\Subscription\Repositories\PackageCourseRepository(new \Modules\Subscription\Entities\PackageCourse);
                $package_course = $packageCourseRepository->model()->where(['course_id' => $data['course']->id, 'status_id' => 4])->first();
                $data['package_included'] = @$package_course ? 1 : 0;
            }
            // package course end
            return view('frontend.course.course_details', compact('data'));
        } else {
            return redirect('/')->with('danger', ___('alert.Course_not_found'));
        }
        // } catch (\Throwable $th) {
        //     return redirect('/')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        // }
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id, $slug)
    {
        try {
            $data['organization'] = $this->organization->model()->where('id', $id)->first(); // data
            if (!$data['organization']) {
                return redirect()->back()->with('danger', ___('alert.organization_not_found'));
            }
            $data['url'] = route('organization.admin.update', [$data['organization']->id, $slug]); // url']
            $data['title'] = ___('organization.Update Organization'); // title
            $data['countries'] = \App\Models\Country::all();
            return view('organization::panel.organization.edit', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(AdminOrganizationRequest $request, $id, $slug)
    {
        try {
            $organization = $this->organization->model()->where('id', $id)->first(); // data
            if (!$organization) {
                return redirect()->back()->with('danger', ___('alert.instructor_not_found'));
            }
            $result = $this->organization->update($request, $organization, $slug);
            if ($result->original['result']) {
                return redirect()->route('organization.admin.index')->with('success', $result->original['message']);
            } else {
                return redirect()->back()->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        try {
            $result = $this->organization->delete($id);
            if ($result->original['result']) {
                return back()->with('success', $result->original['message']);
            } else {
                return back()->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }


    public function requestIndex(Request $request)
    {
        try {
            $data['organizations'] = $this->organization->model()->pending()->search($request)->paginate($request->show ?? 10); // data
            $data['title'] = ___('organization.Organization Request List'); // title
            return view('organization::panel.organization.request', compact('data')); // view
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function suspendIndex(Request $request)
    {
        try {
            $data['organizations'] = $this->organization->model()->suspended()->search($request)->paginate($request->show ?? 10); // data
            $data['title'] = ___('organization.Organization Suspended List'); // title
            return view('organization::panel.organization.suspend', compact('data')); // view
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function approve($id)
    {
        try {
            $organization = $this->organization->model()->where('id', $id)->first(); // data
            if (!$organization) {
                return redirect()->back()->with('danger', ___('alert.organization_not_found'));
            }
            $result = $this->organization->approve($id);
            if ($result->original['result']) {
                return redirect()->back()->with('success', $result->original['message']);
            } else {
                return redirect()->back()->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function reActivate($id)
    {
        try {
            $organization = $this->organization->model()->where('id', $id)->first(); // data
            if (!$organization) {
                return redirect()->back()->with('danger', ___('alert.organization_not_found'));
            }
            $result = $this->organization->reActivate($id);
            if ($result->original['result']) {
                return redirect()->back()->with('success', $result->original['message']);
            } else {
                return redirect()->back()->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function suspend($id)
    {
        try {
            $organization = $this->organization->model()->where('id', $id)->first(); // data
            if (!$organization) {
                return redirect()->back()->with('danger', ___('alert.organization_not_found'));
            }
            $result = $this->organization->suspend($id);
            if ($result->original['result']) {
                return redirect()->back()->with('success', $result->original['message']);
            } else {
                return redirect()->back()->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /* skills */
    public function addSkill(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.skill', $id); // url
            $data['title'] = ___('course.Skills'); // title
            @$data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.skill_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }
    
    public function editFaq(Request $request, $id = null)
    {
        try {
            $data['title'] = "Add faq";
            if ($id) {
                $data['title'] = "Edit faq";
                $data['faq'] = OrgQuestionAnswer::where('id', $id)->first();
            }
            $html = view('organization::panel.organization.modal.edit_faq', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            dd($th);
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }
    //for addcollage_info   

    //for add courses
    public function addCourse(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.course', $id); // url
            $data['title'] = ___('course.courses'); // title
            @$data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.courses_info_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }



    public function addCollegeInfo(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.college_info', $id); // url
            $data['title'] = ___('course.Collage Info'); // title
            @$data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.collage_info_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function addCollegeLink(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.college_link', $id); // url
            $data['title'] = ___('course.College Link'); // title
            @$data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.college_link_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    

    public function storeCollegeLink(CollageinfoLinksRequest $request, $id)
    {
        try {
            $result = $this->organization->storeCollegeLink($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }


    public function addAdmission(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.admission', $id); // url
            $data['title'] = ___('course.Admission'); // title
            @$data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.admission_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function addPlacement(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.placement', $id); // url
            $data['title'] = ___('course.Placement'); // title
            @$data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.placement_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    //for store admission

    public function storeSkill(SkillRequest $request, $id)
    {
        try {
            $result = $this->organization->storeSkill($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    /* skills end */

    public function storeCollegeInfo(CollageinfoRequest $request, $id)
    {
        try {
            $result = $this->organization->storeCollageInfo($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }



    public function storeAdmission(AdmissionRequest $request, $id)
    {
        try {
            $result = $this->organization->storeAdmission($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    //for delete college info
    public function deleteCollegeInfo($key, $id,$field)
    {
        try {
            $result = $this->organization->deleteCollegeInfo($key, $id,$field);
            if ($result->original['result']) {
                return redirect()->back()->with('success', $result->original['message']); // return success response
            } else {
                return redirect()->back()->with('danger', $result->original['message']); // return error response
            } 
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again')); // return error response
        }
    }

   

    //for store

    public function login($id)
    {
        try {
            $data['organization'] = $this->organization->model()->where('id', $id)->first(); // data
            if (!$data['organization']) {
                return redirect()->back()->with('danger', ___('alert.organization_not_found'));
            }
            Auth::loginUsingId($data['organization']->user_id);
            return redirect()->route('organization.dashboard');
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function admission(Request $request, $id)
    {
        try {
            $organization = $this->organization->model()->findOrFail($id);
            $data['organization'] = $organization;
            $data['title'] = ___('organization.Admission Information');
            $data['admissions'] = $organization->admissions()->paginate($request->show ?? 10);

            return view('organization::panel.organization.admission', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function addReviews(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.reviews', $id); // url
            $data['title'] = ___('organization.Add Review'); // title
            $data['button'] = ___('organization.Save Review'); // button
            $data['organization'] = $this->organization->model()->where('id', $id)->first();
            $html = view('organization::panel.organization.modal.reviews_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function storeReview(ReviewRequest $request, $id)
    {
        try {
            $result = $this->organization->storeReview($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function storeReviews(ReviewRequest $request, $id)
    {
        try {
            $result = $this->organization->storeReviews($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function addCampus(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.campus', $id); // url
            $data['title'] = ___('organization.Campus Information'); // title
            $data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.campus_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function addScholarship(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.scholarship', $id); // url
            $data['title'] = ___('organization.Scholarship Information'); // title
            $data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.scholarship_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function addGallery(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.gallery', $id); // url
            $data['title'] = ___('organization.Gallery'); // title
            $data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.gallery_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function storeCourse(CourseRequest $request, $id)
    {
        try {
            $result = $this->organization->storeCourse($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']);
            } else {
                return $this->responseWithError($result->original['message'], [], 400);
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400);
        }
    }

    public function storePlacement(PlacementRequest $request, $id)
    {
        try {
            $result = $this->organization->storePlacement($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function storeCampus(CampusRequest $request, $id)
    {
        try {
            $result = $this->organization->storeCampus($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function storeScholarship(ScholarshipRequest $request, $id)
    {
        try {
            $result = $this->organization->storeScholarship($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function storeGallery(GalleryRequest $request, $id)
    {
        try {
            $result = $this->organization->storeGallery($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function addAdmissionLink(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.admission_link', $id); // url
            $data['title'] = ___('course.Admission Link'); // title
            @$data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.admission_link_edit', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function addLink(Request $request, $id,$field)
    {
        try {
        // dd($field);
            $data['url'] = route('organization.admin.store.link', [$id,$field]); // url
            $data['title'] = $field; // title
            @$data['button'] = ___('organization.Save & Update'); // button
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.add_link', compact('data'))->render(); // render view
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function storeLink(LinkRequest $request, $id,$field)
    {
        try {
            $result = $this->organization->storeLink($request, $id,$field);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function storeAdmissionLink(AdmissionLinksRequest $request, $id)
    {
        try {
            $result = $this->organization->storeAdmissionLink($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']); // return success response
            } else {
                return $this->responseWithError($result->original['message'], [], 400); // return error response
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400); // return error response
        }
    }

    public function addPlacementLink(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.placement_link', $id);
            $data['title'] = ___('organization.Placement Link');
            $data['button'] = ___('organization.Save & Update');
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.placement_link_edit', compact('data'))->render();
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html);
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400);
        }
    }

    public function storePlacementLink(PlacementLinksRequest $request, $id)
    {
        try {
            $result = $this->organization->storePlacementLink($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']);
            } else {
                return $this->responseWithError($result->original['message'], [], 400);
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400);
        }
    }

    public function addCampusLink(Request $request, $id)
    {
        try {
            $data['url'] = route('organization.admin.store.campus_link', $id);
            $data['title'] = ___('organization.Campus Link');
            $data['button'] = ___('organization.Save & Update');
            $data['organization'] = $this->organization->model()->where('user_id', $id)->first();
            $html = view('organization::panel.organization.modal.campus_link_edit', compact('data'))->render();
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $html);
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400);
        }
    }

    public function storeCampusLink(CampusLinksRequest $request, $id)
    {
        try {
            $result = $this->organization->storeCampusLink($request, $id);
            if ($result->original['result']) {
                return $this->responseWithSuccess($result->original['message']);
            } else {
                return $this->responseWithError($result->original['message'], [], 400);
            }
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'), [], 400);
        }
    }
}
