<?php

namespace Modules\organization\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Contracts\Support\Renderable;
use Modules\Slot\Entities\Slot;
use Modules\Slot\Interfaces\SlotInterface;
use Modules\Slot\Http\Requests\CreateSlotRequest;
use Modules\Slot\Http\Requests\UpdateSlotRequest;


class SlotController extends Controller
{
    // constructor injection
    protected $slider;

    public function __construct(SlotInterface $slider)
    {
        $this->slider         = $slider;
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {

        // try {

        $data['tableHeader']    = $this->slider->tableHeader(); // table header
        $data['sliders']        = $this->slider->getAll($request); // data
        $data['title']          = ___('slider.Online Counsiling'); // title


        if ($data['sliders']) {
            return view('organization::panel.organization.slot.index', compact('data')); // view
        }

        return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));

        // } catch (\Throwable $th) {

        //     return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        // }
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {

        try {
            $data['title']              =   ___('slider.Set Slot'); // title
            $data['button']             =   ___('common.create'); // button
            $slots = Slot::where('user_id', auth()->user()->id)->get();
            $data['slots'] = $slots;
            return view('organization::panel.organization.slot.create', compact('data'));
        } catch (\Throwable $th) {

            return redirect()->route('organization.slot.create')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */

    public function store(CreateSlotRequest $request)
    {


        // try {
        $days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];

        foreach ($days as $day) {
            $rules['start_time_' . strtolower($day)] = 'required';
            $rules['end_time_' . strtolower($day)] = 'required|after:start_time_' . strtolower($day);
        }

        $request->validate($rules);

        $result = $this->slider->store($request);
        // dd($result);
        if ($result->original['result']) {
            return redirect()->route('organization.slot.create')->with('success', $result->original['message']);
        } else {
            return redirect()->route('organization.slot.create')->with('danger', $result->original['message']);
        }
        // } catch (\Throwable $th) {

        //     return redirect()->route('organization.slot.create')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        // }
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('organization::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        try {
            $data['title']              = ___('slider.Edit ads'); // title
            $data['button']             = ___('common.update'); // button
            $data['slider']               = $this->slider->model()->find($id);

            return view('organization::slider.edit', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->route('organization.slot.create')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(UpdateSlotRequest $request, $id)
    {
        try {
            $result = $this->slider->update($request, $id);
            if ($result->original['result']) {
                return redirect()->route('organization.slot.create')->with('success', $result->original['message']);
            } else {
                return redirect()->route('organization.slot.create')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->route('organization.slot.create')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        try {
            $result = $this->slider->destroy($id);
            if ($result->original['result']) {
                return redirect()->route('organization.slot.create')->with('success', $result->original['message']);
            } else {
                return redirect()->route('organization.slot.create')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->route('organization.slot.create')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }
}
