<?php

namespace Modules\Organization\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CollageinfoLinksRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "group" => "required",
            "title" => "required",
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [
            'group.required' => ___('validation.title are required'),
            'title.required' => ___('validation.title are required'),
            'url.required' => ___('validation.url are required'),
            'url.url' => ___('validation.url is not valid'),
        ];
    }
}
