@extends('organization::panel.organization.layouts.master')
@section('title', @$data['title'])
@section('content')
<!-- Courses -->
<section>
    <div class="row">
        <!-- Section Tittle -->
        <div class="col-xl-12">
            <div class="small-tittle-two border-bottom d-flex align-items-center justify-content-between flex-wrap gap-10 mb-20 pb-8">

                <div class="country d-flex align-items-center">
                    <span class="country text-title font-600 ml-10">
                        {{ $data['title'] }}
                    </span>
                </div>
                <button class="btn btn-lg ot-btn-primary"
                    onclick="mainModalOpen(`{{ route('organization.admin.add.faq', '0') }}`)">
                    <i class="fa-solid fa-plus"></i>
                    {{ ___('organization.add new') }}</button>
            </div>
        </div>
    </div>
    
    <div class="row">
        @if (@$data['faq'])
        @foreach (@$data['faq'] as $key => $faq)
        <div class="col-xl-12">
            <div class="single-education mb-30 d-flex justify-content-between align-items-start">

                <div class="education-cap">
                    <h4 class="text-18 text-tile mb-15 ">

                        {{ @$faq['question'] }}
                        </h3>


                        <p class="pera mb-6">
                            {{ @$faq['answer'] }}
                        </p>

                </div>
                {{-- Button --}}
                <div class="d-flex gap-10">
                    <button class="btn text-primary border-0 p-0"
                        onclick="mainModalOpen(`{{ route('organization.admin.add.faq', @$faq['id']) }}`)">
                        <i class="fa-solid fa-pen-to-square"></i>
                    </button>
                    <a  href="javascript:void(0);" onclick="deleteFaq(`{{ route('organization.deleteFaq', @$faq['id']) }}`, {{ @$faq['id'] }})">
                        <button class="btn text-primary border-0 p-0">
                            <span class="icon mr-8">
                                <i class="fa-solid fa-trash-can"></i>
                            </span>
                        </button>
                        
                    </a>
                </div>
            </div>
        </div>
        @endforeach
        @endif
        <!-- Educations end -->
    </div>
            
</section>


@endsection
@section('scripts')
<script>
    function copyReferralLink() {
        var copyText = document.querySelector('.referral-link input');
        copyText.select();
        document.execCommand('copy');
        alert('{{ __("Link copied to clipboard!") }}');
    }
    function deleteFaq(route, id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!'
          }).then((confirmed) => {
            if (confirmed.isConfirmed) {
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        _method: 'GET'
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: route,
                })
                .done(function(response) {
                    Swal.fire({
                        title: 'Done', 
                        text: 'Record deleted successfully', 
                        icon: 'success',
                        showCancelButton: false,
                        showConfirmButton: false
                    });
                    setTimeout(function () {
                        location.reload();
                    }, 1000);
                })
                .fail(function(error) {
                    Swal.fire('{{ ___('common.opps') }}...', '{{ ___('common.something_went_wrong_with_ajax') }}', 'error');
                })
            }
          });
    };

</script>
@endsection