<div class="step-wrapper-contents active">
    <!-- Step 1 -->
    <div class="step-1">
        <!-- Title -->
        <div class="setp-page-title mb-20">
            <h4 class="title font-600">
                <i class="ri-folder-add-line"></i> {{ ___('course.General') }}
            </h4>
        </div>
        <div class="row">
            <!-- Course Title -->
            <div class="col-lg-12">
                <div class="ot-contact-form course-title mb-24">
                    <input class="form-control ot-contact-input" type="text" name="title" id="title"
                        value="{{ old('title') }}" placeholder="{{ ___('placeholder.Course Title....') }}">
                </div>
            </div>
            <div class="col-lg-6">
                <!-- Select Categories -->
                <div class="ot-contact-form mb-24">
                    <div class="ot-contact-form">
                        <label class="ot-contact-label">{{ ___('label.Category') }} <span class="text-danger">*</span>
                        </label>
                        <input type="hidden" name="language_id" value="en">
                        <input type="hidden" name="course_level" value="20">
                        <input type="hidden" name="course_type" value="14">
                        <input type="hidden" name="is_free" value="1">




                        <select class="form-control ot-contact-input select2" id="category" name="category">
                            <option selected="" disabled="" value="">
                                {{ ___('placeholder.Select Category') }}
                            </option>
                            @foreach (@$data['categories'] as $category)
                            <?= categoryBacktracking($category->id, '', null) ?>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-6">

                <div class="ot-contact-form mb-24">
                    <div class="ot-contact-form">
                        <label class="ot-contact-label">{{ ___('label.Visibility') }} <span class="text-danger">*</span>
                        </label>
                        <select class="form-control ot-contact-input select2" id="visibility_id" required
                            name="visibility_id">
                            @foreach (courseVisibility() as $visibility)
                            <option value="{{ $visibility->id }}"
                                {{ old('course_level') == $visibility->id ? ' selected="selected"' : '' }}>
                                {{ $visibility->name }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <!-- Select level -->

            </div>

            <div class="col-lg-12">
                <!-- Course Includes-->
                <div class="ot-contact-form mb-24">
                    <label class="ot-contact-label">{{ ___('label.Short description') }}</label>
                    <textarea class="form-control ot-textarea @error('short_description') is-invalid @enderror" name="short_description"
                        id="short_description" rows="5" placeholder="{{ ___('placeholder.Enter Short Description') }}">{{ old('short_description') }}</textarea>
                </div>
                <!-- Course Descriptions [ CK Editor ]-->
                <div class="ot-contact-form mb-24">
                    <label class="ot-contact-label">{{ ___('label.description') }}</label>
                    <textarea class="ckeditor-editor" placeholder="{{ ___('placeholder.Enter Description') }}" name="description"
                        id="description">{{ old('description') }}</textarea>
                </div>
            </div>
            <div class="multiStep-wrapper-contents step2 ">
                <div class="mb-24 border-0 pt-0">

                    <div class="row">
                        {{-- start Requirements  --}}


                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="overview"
                                class="form-label ">{{ ___('course.Course Overview') }}
                            </label>

                            <textarea class="form-control ckeditor-editor @error('overview') is-invalid @enderror" name="overview"
                                id="overview" rows="5">
                            {{ old('overview') }}
                            </textarea>
                            @error('overview')
                            <div id="validationServer04Feedback" class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>

                        {{-- end Requirements  --}}
                        {{-- start Requirements  --}}

                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="eligibility"
                                class="form-label ">{{ ___('course.Eligibility') }}
                            </label>
                            <textarea class="form-control ckeditor-editor @error('eligibility') is-invalid @enderror" name="eligibility"
                                id="eligibility" rows="5">
                            {{ old('eligibility') }}
                            </textarea>
                            @error('eligibility')
                            <div id="validationServer04Feedback" class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        {{-- end Requirements  --}}


                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="curriculum"
                                class="form-label ">{{ ___('course.Course Curriculum') }}
                            </label>
                            <textarea class="form-control ckeditor-editor @error('curriculum') is-invalid @enderror" name="curriculum"
                                id="curriculum" rows="5">
                            {{ old('curriculum') }}
                            </textarea>
                            @error('curriculum')
                            <div id="validationServer04Feedback" class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>

                        {{-- end Requirements  --}}


                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="fees"
                                class="form-label ">{{ ___('course.Course Fees') }}
                            </label>
                            <textarea class="form-control ckeditor-editor @error('fees') is-invalid @enderror" name="fees"
                                id="fees" rows="5">
                            {{ old('fees') }}
                            </textarea>
                            @error('fees')
                            <div id="validationServer04Feedback" class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>

                        {{-- end Requirements  --}}


                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="career_opportunity"
                                class="form-label ">{{ ___('course.Career Opportunity') }}
                            </label>
                            <textarea class="form-control ckeditor-editor @error('career_opportunity') is-invalid @enderror" name="career_opportunity"
                                id="career_opportunity" rows="5">
                            {{ old('career_opportunity') }}
                            </textarea>
                            @error('career_opportunity')
                            <div id="validationServer04Feedback" class="invalid-feedback">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>

                        {{-- end Requirements  --}}



                    </div>

                </div>
            </div>

        </div>
    </div>
</div>