<div class="card ot-card">
    <div class="card-body">
        <form method="POST" action="{{ @$data['url'] }}" enctype="multipart/form-data">
            @csrf
            {{-- Style Two --}}
            <div class="row mb-3 row mb-3 d-flex justify-content-center">
                <div class="col-lg-6">
                    <div class="small-tittle-two border-bottom mb-20 pb-8">
                        <h4 class="title text-capitalize font-600">
                            {{ ___('organization.Personal Information') }}
                        </h4>
                    </div>
                    <div class="row">
                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="name" class="form-label ">{{ ___('organization.Name') }} <span
                                    class="fillable">*</span></label>
                            <input class="form-control ot-input @error('name') is-invalid @enderror" name="name"
                                value="{{ $data['organization']->user->name }}" id="name"
                                placeholder="{{ ___('placeholder.Enter Name') }}">
                            @error('name')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="phone" class="form-label ">{{ ___('organization.Phone') }} <span
                                    class="fillable">*</span></label>
                            <input class="form-control ot-input @error('phone') is-invalid @enderror" name="phone"
                                value="{{ $data['organization']->user->phone }}" id="phone"
                                placeholder="{{ ___('placeholder.Enter Phone') }}">
                            @error('phone')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="address" class="form-label ">{{ ___('organization.Address') }} </label>
                            <input class="form-control ot-input @error('address') is-invalid @enderror" name="address"
                                value="{{ $data['organization']->address }}" id="address"
                                placeholder="{{ ___('placeholder.Enter Address') }}">
                            @error('address')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>


                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="state" class="form-label ">{{ ___('organization.State') }} <span
                                    class="fillable">*</span></label>

                            @php
                                $states = [
                                    'Andhra Pradesh',
                                    'Arunachal Pradesh',
                                    'Assam',
                                    'Bihar',
                                    'Chhattisgarh',
                                    'Goa',
                                    'Gujarat',
                                    'Haryana',
                                    'Himachal Pradesh',
                                    'Jharkhand',
                                    'Karnataka',
                                    'Kerala',
                                    'Madhya Pradesh',
                                    'Maharashtra',
                                    'Manipur',
                                    'Meghalaya',
                                    'Mizoram',
                                    'Nagaland',
                                    'Odisha',
                                    'Punjab',
                                    'Rajasthan',
                                    'Sikkim',
                                    'Tamil Nadu',
                                    'Telangana',
                                    'Tripura',
                                    'Uttar Pradesh',
                                    'Uttarakhand',
                                    'West Bengal',
                                    'Delhi',
                                    'Andaman and Nicobar Islands',
                                    'Chandigarh',
                                    'Dadra and Nagar Haveli',
                                    'Daman and Diu',
                                    'Lakshadweep',
                                    'Puducherry',
                                ];
                            @endphp

                            <select id="state" name="state"
                                class="form-control ot-input @error('state') is-invalid @enderror">
                                <option value="">Select State</option>
                                @foreach ($states as $state)
                                    <option value="{{ $state }}"
                                        {{ $data['organization']->state == $state ? 'selected' : '' }}>
                                        {{ $state }}</option>
                                @endforeach
                            </select>
                            @error('state')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="city" class="form-label ">{{ ___('organization.City') }} <span
                                    class="fillable">*</span></label>
                            <select id="city" class="form-control ot-input @error('city') is-invalid @enderror"
                                name="city">
                                <option value>-- Select City --</option>
                            </select>
                            @error('city')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="small-tittle-two border-bottom mb-20 pb-8">
                        <h4 class="title text-capitalize font-600">{{ ___('organization.About Information') }}
                        </h4>
                    </div>
                    <div class="row">

                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="established_year"
                                class="form-label ">{{ ___('organization.Established Year') }} <span
                                    class="fillable">*</span></label>
                            <input class="form-control ot-input @error('established_year') is-invalid @enderror"
                                name="established_year" value="{{ $data['organization']->established_year }}"
                                id="established_year" placeholder="{{ ___('placeholder.Enter Established Year') }}">
                            @error('established_year')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="website" class="form-label ">{{ ___('organization.Website') }} <span
                                    class="fillable">*</span></label>
                            <input class="form-control ot-input @error('website') is-invalid @enderror" name="website"
                                value="{{ $data['organization']->website }}" id="website"
                                placeholder="{{ ___('placeholder.Enter Website') }}">
                            @error('website')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="designation" class="form-label ">
                                {{ ___('organization.About') }}
                            </label>
                            <textarea class="ot-textarea form-control  @error('about_me') is-invalid @enderror" id="text" rows="6"
                                placeholder="{{ ___('organization.About Organization') }}" name="about_me" id="" rows="10"><?= @$data['organization']->about_me ?></textarea>
                            @error('about_me')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="designation" class="form-label ">
                                {{ ___('organization.Logo') }}
                            </label>

                            <div @if ($data['organization']->user->image) data-val="{{ showImage($data['organization']->user->image->original, 'default-1.jpeg') }}" @endif
                                data-name="profile_image" class="file @error('profile_image') is-invalid @enderror"
                                data-height="200px ">
                            </div>
                            <small
                                class="text-muted">{{ ___('placeholder.NB : Logo size will 100px x 100px and not more than 1mb') }}</small>
                            @error('profile_image')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="designation" class="form-label ">
                                {{ ___('organization.Cover Image') }}
                            </label>

                            <div @if ($data['organization']->cover_image) data-val="{{ showImage($data['organization']->cover->original, 'backend/uploads/default-images/default-1.jpeg') }}" @endif
                                data-name="cover_image" class="file @error('cover_image') is-invalid @enderror"
                                data-height="200px ">
                            </div>
                            <small
                                class="text-muted">{{ ___('placeholder.NB : Cover Image size will 100px x 100px and not more than 1mb') }}</small>
                            @error('cover_image')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="designation" class="form-label ">
                                Thumbnail Image
                            </label>

                            <div @if ($data['organization']->thumbnail_image) data-val="{{ showImage($data['organization']->thumbnail->original, 'backend/uploads/default-images/default-1.jpeg') }}" @endif
                                data-name="thumbnail_image"
                                class="file @error('thumbnail_image') is-invalid @enderror" data-height="200px ">
                            </div>
                            <small class="text-muted">Thumbnail Image size will 100px x 100px and not more than
                                1mb</small>
                            @error('thumbnail_image')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="organization_type"
                                class="form-label">{{ ___('organization.Organization Type') }} <span
                                    class="fillable">*</span></label>
                            <select
                                class="form-select select2 ot-input @error('organization_type') is-invalid @enderror"
                                id="organization_type" name="organization_type">
                                <option value="">{{ ___('placeholder.Select Organization Type') }}</option>
                                <option value="1" @if ($data['organization']->organization_type == 1) selected @endif>
                                    {{ ___('organization.Public') }}</option>
                                <option value="2" @if ($data['organization']->organization_type == 2) selected @endif>
                                    {{ ___('organization.Private') }}</option>
                            </select>
                            @error('organization_type')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                        <div class="col-xl-12 col-md-6 mb-3">
                            <label for="brochure" class="form-label">{{ ___('organization.Brochure') }}
                                <span class="fillable">*</span></label>
                            {{ showImage($data['organization']->brochure->original) }}
                            <input type="file" name="brochure" id="brochure" class="form-control">
                            @error('brochure')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                    </div>
                </div>
                <div class="col-md-12 mt-24">
                    <div class="text-end">
                        <button class="btn btn-lg ot-btn-primary"><span>
                            </span>{{ ___('common.Update') }}</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
