@extends('organization::panel.organization.layouts.master')

@section('title', @$data['title'])
@push('style')
<link rel="stylesheet" href="{{ asset('backend/assets/css/tagify.css') }}">
@endpush
@section('content')
<div>
    @include('organization::panel.organization.partials.profile_tab')
    <!-- @include('organization::panel.organization.partials.general') -->
    <!-- general body start -->

    @if (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'general']))
    @include('organization::panel.organization.partials.general')

    <!-- general body end -->
    @elseif (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'security']))
    <!-- security body start -->
    @include('organization::panel.organization.partials.security')
    <!-- security body end -->
    @elseif (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'skill']))
    <!-- skill body start -->
    @include('organization::panel.organization.partials.skill')
    <!-- skill body end -->
    @elseif (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'college_info']))
    <!-- collage info body start -->
    @include('organization::panel.organization.partials.collage-info')
    <!-- collage info body end -->
    @elseif (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'courses']))
    <!-- courses body start -->
    @include('organization::panel.organization.partials.courses')
    <!-- courses body end -->
    @elseif (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'admission']))
    <!-- admission body start -->
    @include('organization::panel.organization.partials.admission')
    <!-- admission body end -->
    @elseif (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'placement']))
    <!-- placement body start -->
    @include('organization::panel.organization.partials.placement')
    <!-- placement body end -->
    @elseif (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'reviews']))
    <!-- reviews body start -->
    @include('organization::panel.organization.partials.reviews')
    <!-- reviews body end -->
    @elseif (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'campus']))
    <!-- campus body start -->
    @include('organization::panel.organization.partials.campus')
    <!-- campus body end -->
    @elseif (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'scholarship']))
    <!-- scholarship body start -->
    @include('organization::panel.organization.partials.scholarship')
    <!-- scholarship body end -->
    @elseif (url()->current() === route('organization.profile.edit', [$data['organization']->user_id, 'gallery']))
    <!-- gallery body start -->
    @include('organization::panel.organization.partials.gallery')
    <!-- gallery body end -->
    @endif
</div>
@endsection

@section('scripts')
<script>
    const stateCityData = {
        "Andaman and Nicobar Islands": ["Port Blair"],
        "Andhra Pradesh": ["Adoni", "Amaravati", "Anantapur", "Chandragiri", "Chittoor", "Dowlaiswaram", "Eluru", "Guntur", "Kadapa", "Kakinada", "Kurnool", "Machilipatnam", "Nagarjunakoṇḍa", "Rajahmundry", "Srikakulam", "Tirupati", "Vijayawada", "Visakhapatnam", "Vizianagaram", "Yemmiganur"],
        "Arunachal Pradesh": ["Itanagar"],
        "Assam": ["Dhuburi", "Dibrugarh", "Dispur", "Guwahati", "Jorhat", "Nagaon", "Sivasagar", "Silchar", "Tezpur", "Tinsukia"],
        "Bihar": ["Ara", "Barauni", "Begusarai", "Bettiah", "Bhagalpur", "Bihar Sharif", "Bodh Gaya", "Buxar", "Chapra", "Darbhanga", "Dehri", "Dinapur Nizamat", "Gaya", "Hajipur", "Jamalpur", "Katihar", "Madhubani", "Motihari", "Munger", "Muzaffarpur", "Patna", "Purnia", "Pusa", "Saharsa", "Samastipur", "Sasaram", "Sitamarhi", "Siwan"],
        "Chandigarh": ["Chandigarh"],
        "Chhattisgarh": ["Ambikapur", "Bhilai", "Bilaspur", "Dhamtari", "Durg", "Jagdalpur", "Raipur", "Rajnandgaon"],
        "Dadra and Nagar Haveli and Daman and Diu": ["Daman", "Diu", "Silvassa"],
        "Delhi": ["Delhi", "New Delhi"],
        "Goa": ["Madgaon", "Panaji"],
        "Gujarat": ["Ahmadabad", "Amreli", "Bharuch", "Bhavnagar", "Bhuj", "Dwarka", "Gandhinagar", "Godhra", "Jamnagar", "Junagadh", "Kandla", "Khambhat", "Kheda", "Mahesana", "Morbi", "Nadiad", "Navsari", "Okha", "Palanpur", "Patan", "Porbandar", "Rajkot", "Surat", "Surendranagar", "Valsad", "Veraval"],
        "Haryana": ["Ambala", "Bhiwani", "Chandigarh", "Faridabad", "Firozpur Jhirka", "Gurugram", "Hansi", "Hisar", "Jind", "Kaithal", "Karnal", "Kurukshetra", "Panipat", "Pehowa", "Rewari", "Rohtak", "Sirsa", "Sonipat"],
        "Himachal Pradesh": ["Bilaspur", "Chamba", "Dalhousie", "Dharmshala", "Hamirpur", "Kangra", "Kullu", "Mandi", "Nahan", "Shimla", "Una"],
        "Jammu and Kashmir": ["Anantnag", "Baramula", "Doda", "Gulmarg", "Jammu", "Kathua", "Punch", "Rajouri", "Srinagar", "Udhampur"],
        "Jharkhand": ["Bokaro", "Chaibasa", "Deoghar", "Dhanbad", "Dumka", "Giridih", "Hazaribag", "Jamshedpur", "Jharia", "Rajmahal", "Ranchi", "Saraikela"],
        "Karnataka": ["Badami", "Ballari", "Bengaluru", "Belagavi", "Bhadravati", "Bidar", "Chikkamagaluru", "Chitradurga", "Davangere", "Halebid", "Hassan", "Hubballi-Dharwad", "Kalaburagi", "Kolar", "Madikeri", "Mandya", "Mangaluru", "Mysuru", "Raichur", "Shivamogga", "Shravanabelagola", "Shrirangapattana", "Tumakuru", "Vijayapura"],
        "Kerala": ["Alappuzha", "Vatakara", "Idukki", "Kannur", "Kochi", "Kollam", "Kottayam", "Kozhikode", "Mattancheri", "Palakkad", "Thalassery", "Thiruvananthapuram", "Thrissur"],
        "Ladakh": ["Kargil", "Leh"],
        "Madhya Pradesh": ["Balaghat", "Barwani", "Betul", "Bharhut", "Bhind", "Bhojpur", "Bhopal", "Burhanpur", "Chhatarpur", "Chhindwara", "Damoh", "Datia", "Dewas", "Dhar", "Dr. Ambedkar Nagar (Mhow)", "Guna", "Gwalior", "Hoshangabad", "Indore", "Itarsi", "Jabalpur", "Jhabua", "Khajuraho", "Khandwa", "Khargone", "Maheshwar", "Mandla", "Mandsaur", "Morena", "Murwara", "Narsimhapur", "Narsinghgarh", "Narwar", "Neemuch", "Nowgong", "Orchha", "Panna", "Raisen", "Rajgarh", "Ratlam", "Rewa", "Sagar", "Sarangpur", "Satna", "Sehore", "Seoni", "Shahdol", "Shajapur", "Sheopur", "Shivpuri", "Ujjain", "Vidisha"],
        "Maharashtra": ["Ahmadnagar", "Akola", "Amravati", "Aurangabad", "Bhandara", "Bhusawal", "Bid", "Chandrapur", "Daulatabad", "Dhule", "Jalgaon", "Kalyan", "Karli", "Kolhapur", "Mahabaleshwar", "Malegaon", "Matheran", "Mumbai", "Nagpur", "Nanded", "Nashik", "Osmanabad", "Pandharpur", "Parbhani", "Pune", "Ratnagiri", "Sangli", "Satara", "Sevagram", "Solapur", "Thane", "Ulhasnagar", "Vasai-Virar", "Wardha", "Yavatmal"],
        "Manipur": ["Imphal"],
        "Meghalaya": ["Cherrapunji", "Shillong"],
        "Mizoram": ["Aizawl", "Lunglei"],
        "Nagaland": ["Kohima", "Mon", "Phek", "Wokha", "Zunheboto"],
        "Odisha": ["Balangir", "Baleshwar", "Baripada", "Bhubaneshwar", "Brahmapur", "Cuttack", "Dhenkanal", "Kendujhar", "Konark", "Koraput", "Paradip", "Phulabani", "Puri", "Sambalpur", "Udayagiri"],
        "Puducherry": ["Karaikal", "Mahe", "Puducherry", "Yanam"],
        "Punjab": ["Amritsar", "Batala", "Chandigarh", "Faridkot", "Firozpur", "Gurdaspur", "Hoshiarpur", "Jalandhar", "Kapurthala", "Ludhiana", "Nabha", "Patiala", "Rupnagar", "Sangrur"],
        "Rajasthan": ["Abu", "Ajmer", "Alwar", "Amer", "Barmer", "Beawar", "Bharatpur", "Bhilwara", "Bikaner", "Bundi", "Chittaurgarh", "Churu", "Dhaulpur", "Dungarpur", "Ganganagar", "Hanumangarh", "Jaipur", "Jaisalmer", "Jalor", "Jhalawar", "Jhunjhunun", "Jodhpur", "Kishangarh", "Kota", "Merta", "Nagaur", "Nathdwara", "Pali", "Phalodi", "Pushkar", "Sawai Madhopur", "Shahpura", "Sikar", "Sirohi", "Tonk", "Udaipur"],
        "Sikkim": ["Gangtok", "Gyalsing", "Lachung", "Mangan"],
        "Tamil Nadu": ["Arcot", "Chengalpattu", "Chennai", "Chidambaram", "Coimbatore", "Cuddalore", "Dharmapuri", "Dindigul", "Erode", "Kanchipuram", "Kanniyakumari", "Kodaikanal", "Kumbakonam", "Madurai", "Mamallapuram", "Nagapattinam", "Nagercoil", "Palayamkottai", "Pudukkottai", "Rajapalaiyam", "Ramanathapuram", "Salem", "Thanjavur", "Tiruchchirappalli", "Tirunelveli", "Tiruppur", "Tuticorin", "Udhagamandalam", "Vellore"],
        "Telangana": ["Hyderabad", "Karimnagar", "Khammam", "Mahbubnagar", "Nizamabad", "Sangareddi", "Warangal"],
        "Tripura": ["Agartala"],
        "Uttar Pradesh": ["Agra", "Aligarh", "Amroha", "Ayodhya", "Azamgarh", "Bahraich", "Ballia", "Banda", "Bara Banki", "Bareilly", "Basti", "Bijnor", "Bithur", "Bulandshahr", "Deoria", "Etah", "Etawah", "Faizabad", "Farrukhabad-cum-Fatehgarh", "Fatehpur", "Firozabad", "Ghaziabad", "Ghazipur", "Gonda", "Gorakhpur", "Hamirpur", "Hardoi", "Hathras", "Jaunpur", "Jhansi", "Kannauj", "Kanpur", "Lakhimpur", "Lalitpur", "Lucknow", "Mainpuri", "Mathura", "Meerut", "Mirzapur-Vindhyachal", "Moradabad", "Muzaffarnagar", "Partapgarh", "Pilibhit", "Prayagraj", "Rae Bareli", "Rampur", "Saharanpur", "Sambhal", "Shahjahanpur", "Sitapur", "Sultanpur", "Tehri", "Unnao", "Varanasi"],
        "Uttarakhand": ["Almora", "Dehra Dun", "Haridwar", "Mussoorie", "Nainital", "Pithoragarh", "Rishikesh"],
        "West Bengal": ["Alipore", "Alipur Duar", "Asansol", "Bally", "Balurghat", "Bankura", "Baranagar", "Barasat", "Barrackpore", "Basirhat", "Bhatpara", "Bishnupur", "Budge Budge", "Burdwan", "Chandernagore", "Darjiling", "Diamond Harbour", "Dum Dum", "Durgapur", "Halisahar", "Haora", "Hugli-Chinsurah", "Ingraj Bazar", "Jalpaiguri", "Kalimpong", "Kamarhati", "Kanchrapara", "Kharagpur", "Kolkata", "Krishnanagar", "Malda", "Midnapore", "Murshidabad", "Navadwip", "Palashi", "Purulia", "Raiganj", "Santipur", "Shantiniketan", "Shrirampur", "Siliguri", "Siuri", "Tamluk", "Titagarh"],
    };

    document.getElementById("state").addEventListener("change", function() {
        const state = this.value;
        const citySelect = document.getElementById("city");
        citySelect.innerHTML = '<option value="">-- Select City --</option>';

        if (state && stateCityData[state]) {
            stateCityData[state].forEach(function(city) {
                const option = document.createElement("option");
                option.value = city;
                option.textContent = city;
                if (city === "{{ $data['organization']->city }}") {
                    option.selected = true;
                }
                citySelect.appendChild(option);
            });
        }
    });

    // Trigger change event on page load to set the initial city
    document.getElementById("state").dispatchEvent(new Event('change'));
</script>

<script src="{{ asset('backend/assets/js/tagify.js') }}"></script>
@endsection