@extends('organization::panel.organization.layouts.master')

@section('title', @$data['title'])
@section('content')
<!-- Dashboard Card Start -->
<style>
    .pricing {
        display: flex;
        justify-content: center;
        align-items: center;


        isolation: isolate;
    }

    @media (max-width: 540px) {
        .pricing {
            flex-direction: column;
        }
    }

    .card {
        flex: 1;
        max-width: 300px;
        padding: 16px 32px;
        border-radius: 8px;
        background: white;
        box-shadow: 0px 2px 16px hsl(260deg 50% 20% / 0.7);


        position: relative;
        z-index: 1;
    }

    .primary.card {
        flex: 1.25;
        max-width: 350px;


        z-index: 2;
        margin: -32px -16px;
    }

    .card h2 {
        font-size: 1rem;
        font-weight: 500;
        color: hsl(0deg 0% 40%);
    }

    .price {
        font-size: 2rem;
        font-weight: 700;
    }

    .card button {
        width: 100%;
        height: 3rem;
    }
</style>
<!-- End-of card -->
<!-- instructor Courses activity Start -->
<section class="instructor-courses-activity">
    <div class="row">
        <!-- Section Title -->
        <div class="col-xl-12">
            <div class="section-title-two d-flex align-items-center justify-content-between flex-wrap">
                <h2 class="title font-600 mb-20">{{ $data['title'] }}</h2>
                <div class="right d-flex flex-wrap justify-content-between">
                </div>
            </div>
        </div>
    </div>

</section>

<section class="pricing">
    @foreach ($data['subscriptions'] as $subscription)
    <article class="card {{ (auth()->user()->subscription_id == $subscription->id) ? 'primary':'' }}">
        <h2>{{ $subscription->name }}</h2>
        <div class="price">₹ {{ $subscription->price }} / <span style="font-size:12px"> {{ $subscription->duration_type }}</span> </div>

        <ul>
            @foreach ($subscription->features as $feature)
            <li>{{ $feature->value }} {{ $feature->name }}</li>
            @endforeach

        </ul>

        @if (auth()->user()->subscription_id == $subscription->id)
        <div class="p-3">
            <form action="{{ route('subscription.organization.upgrade', $subscription->id) }}" method="post">
                @csrf
                <button type="submit" class="btn btn-primary">Upgrade</button>
            </form>
        </div>
        @else
        <div class="p-3">

            <form action="{{ route('organization.subscription.subscribe', $subscription->id) }}" method="post">
                @csrf
                <button type="submit" class="btn btn-primary">Subscribe</button>
            </form>
        </div>
        @endif
    </article>
    @endforeach



</section>
<!-- End-of courses activity  -->
<!--  pagination start -->

<!--  pagination end -->
@endsection