<?php

namespace Modules\Slot\Entities;

use App\Traits\Relationship\StatusRelationTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Slot extends Model
{
    use HasFactory, StatusRelationTrait;

    protected $fillable = ['user_id', 'day', 'start_time', 'end_time', 'status_id', 'image_id'];

    protected static function booted()
    {
        static::created(function ($slots) { // when slot created then forget cache
            cache()->forget('slots');
        });

        static::updated(function ($slot) { // when slot updated then forget cache
            cache()->forget('slots');
        });

        static::deleted(function ($slot) { // when slot deleted then forget cache
            cache()->forget('slots');
        });
    }

    // image relation with upload
    public function iconImage(): BelongsTo
    {
        return $this->belongsTo('App\Models\Upload', 'image_id');
    }

    // active
    public function scopeActive($query)
    {
        return $query->where('status_id', 1);
    }

}
