<?php

namespace Modules\Stream\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Contracts\Support\Renderable;
use Modules\Stream\Interfaces\StreamInterface;
use Modules\Stream\Http\Requests\CreateStreamRequest;
use Modules\Stream\Http\Requests\UpdateStreamRequest;

class StreamController extends Controller
{
    // constructor injection
    protected $stream;

    public function __construct(StreamInterface $stream)
    {
        $this->stream = $stream;
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {
        try {
            $data['tableHeader'] = $this->stream->tableHeader(); // table header
            $data['streams'] = $this->stream->model()->search($request->search)->paginate($request->show ?? 10); // data
            $data['title'] = ___('blog.Stream'); // title
            if ($data['streams']) {
                return view('stream::index', compact('data')); // view
            }

            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {

        try {
            $data['title'] = ___('Create Stream'); // title
            $data['button'] = ___('common.create'); // button
            return view('stream::create', compact('data'));
        } catch (\Throwable $th) {

            return redirect()->route('admin.stream.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(CreateStreamRequest $request)
    {
        try {
            $result = $this->stream->store($request);
            if ($result->original['result']) {
                return redirect()->route('admin.stream.index')->with('success', $result->original['message']);
            } else {
                return redirect()->route('admin.stream.index')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->route('admin.stream.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('Stream::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        try {
            $data['title']      = ___('blog.Edit Stream'); // title
            $data['button']     = ___('common.update'); // button
            $data['category']   = $this->stream->model()->find($id);
            return view('stream::edit', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->route('admin.stream.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(UpdateStreamRequest $request, $id)
    {
        try {
            $result = $this->stream->update($request, $id);
            if ($result->original['result']) {
                return redirect()->route('admin.stream.index')->with('success', $result->original['message']);
            } else {
                return redirect()->route('admin.stream.index')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->route('admin.stream.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        try {
            $result = $this->stream->destroy($id);
            if ($result->original['result']) {
                return redirect()->route('admin.stream.index')->with('success', $result->original['message']);
            } else {
                return redirect()->route('admin.stream.index')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->route('admin.stream.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }
}
