<?php

use Illuminate\Support\Facades\Route;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



// Modules/Stream/Routes/web.php

Route::prefix('admin')->middleware(['auth.routes'])->group(function () {
    Route::get('/', 'StreamController@index')->name('admin.stream.index')->middleware('PermissionCheck:stream_read');
    Route::get('/create', 'StreamController@create')->name('admin.stream.create')->middleware('PermissionCheck:stream_create');
    Route::post('/store', 'StreamController@store')->name('admin.stream.store')->middleware('PermissionCheck:stream_store');
    Route::get('/edit/{id}', 'StreamController@edit')->name('admin.stream.edit')->middleware('PermissionCheck:stream_update');
    Route::put('/update/{id}', 'StreamController@update')->name('admin.stream.update')->middleware('PermissionCheck:stream_update');
    Route::get('/delete/{id}', 'StreamController@destroy')->name('admin.stream.delete')->middleware('PermissionCheck:stream_delete');
    
});