<?php

namespace Modules\Student\Entities;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Instructor\Entities\Instructor;
use Modules\Student\Entities\Student;

class Referral extends Model
{
    use HasFactory;
    protected $table = 'referrals';

    protected $fillable = [
        'user_id',
        'reffered_by',
        'referral_code',
        'used_at',
    ];

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function referred()
    {
        return $this->belongsTo(User::class, 'reffered_by');
    }

  
}
