<?php

namespace App\Http\Controllers\Frontend;

use App\Enums\Role;
use App\Http\Controllers\Controller;
use App\Traits\ApiReturnFormatTrait;
use Modules\Course\Interfaces\CourseInterface;
use Modules\Organization\Entities\CourseCallbackRequest;
use Modules\Organization\Interfaces\InstructorCommissionInterface;
use Modules\Organization\Entities\Organization;
use Modules\Organization\Entities\OrgQuestionAnswer;
use Modules\Stream\Entities\Stream;
use Illuminate\Http\Request;

class CourseDetailsController extends Controller
{
    use ApiReturnFormatTrait;

    // constructor injection
    protected $course;
    protected $instructorCommissionInterface;

    public function __construct(CourseInterface $courseInterface, InstructorCommissionInterface $instructorCommissionInterface)
    {
        $this->course = $courseInterface;
        $this->instructorCommissionInterface = $instructorCommissionInterface;
    }

    public function index($slug)
    {
        // dd('course details');
        // try {
        $data['title'] = ___('frontend.Course Details'); // title
        $data['course'] = $this->course->model()->slug($slug)->first();
        
        if (!$data['course'] || !$data['course']->user) {
            return redirect('/')->with('danger', ___('alert.something_went_wrong_please_try_again'));
            
        }
        if ($data['course']->user->role_id == Role::INSTRUCTOR) {
            
            $data['user_type'] = ___('frontend.Instructor');
            $data['profile'] = view('frontend.partials.course.instructor_profile', compact('data'))->render();
        } else {
            $data['user_type'] = ___('frontend.Organization');
            $data['instructors'] = $this->instructorCommissionInterface->model()->where('course_id', $data['course']->id)->get();
            $data['profile'] = view('organization::panel.organization.frontend.partials.organization_profile', compact('data'))->render();
        }
        $data['review'] = view('frontend.partials.course.reviews', compact('data'))->render();
        $data['curriculum'] = view('frontend.partials.course.curriculum', ['sections' => $data['course']->sections])->render();

        if ($data['course']) {
            // package course
            if (module('Subscription') && setting('subscription_setup')) {
                $packageCourseRepository = new \Modules\Subscription\Repositories\PackageCourseRepository(new \Modules\Subscription\Entities\PackageCourse);
                $package_course = $packageCourseRepository->model()->where(['course_id' => $data['course']->id, 'status_id' => 4])->first();
                $data['package_included'] = @$package_course ? 1 : 0;
            }
            // package course end
            
            return view('frontend.course.course_details', compact('data'));
        } else {
            return redirect('/')->with('danger', ___('alert.Course_not_found'));
        }
        // } catch (\Throwable $th) {
        //     return redirect('/')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        // }
    }

    function callbackRequest(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'phone' => 'required',
            'course_id' => 'required'
        ]);

        $courseCallbackRequest = new CourseCallbackRequest();
        $courseCallbackRequest->course_id = $request->course_id;
        $courseCallbackRequest->name = $request->name;
        $courseCallbackRequest->phone = $request->phone;
        $courseCallbackRequest->save();

        return redirect()->back()->with('success', 'Request submitted successfully call you soon.');
    }

    public function showOrganizationDetails($slug)
    {
        // dd($slug);
        // try {
            $organization = Organization::where('slug',$slug)->first();

            if (!$organization) {
                return redirect()->back()->with('error', 'Organization not found.');
            }
            //select all streams
            $streams = Stream::get();
            
            $faq = OrgQuestionAnswer::where('org_id', $organization->user_id)->get();
            
            // dd($organization->id);
            
            if (!$organization->user) {
                return redirect()->back()->with('error', 'Organization not active yet.');
            }
            
            $data = [
                'title' => $organization->user->name,
                'organization' => $organization,
                'about' => $organization->about_me,
                'description' => $organization->description,
                'admission' => $organization->admission,
                'placement' => $organization->placement,
                'campus' => $organization->campus,
                'gallery' => $organization->gallery,
                'reviews' => $organization->reviews,
                'scholarships' => $organization->scholarships,
                'college_info' => $organization->college_info,
                'admission' => $organization->admission,
                'admission_links' => $organization->admission_links,
                'placement' => $organization->placement,
                'placement_links' => $organization->placement_links,
                'campus' => $organization->campus,
                'campus_links' => $organization->campus_links,
                'scollorship' => $organization->scollorship,
                'scollorship_links' => $organization->scollorship_links,
                'college_links' => $organization->college_links,
                'course' => $organization->course,
                'gallery' => $organization->gallery,
                'courses' => $organization->courses()->with('category')->get(),
                'streams' => $streams,
                'faq' => $faq
            ];
            // dd($data);

            return view('frontend.organization.organization_details', compact('data'));
        // } catch (\Exception $e) {
        //     return redirect()->back()->with('error', 'Organization not found.');
        // }
    }
}
