<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Traits\ApiReturnFormatTrait;
use Illuminate\Http\Request;
use Modules\Organization\Interfaces\OrganizationInterface;

class InstituteController extends Controller
{
    use ApiReturnFormatTrait;

    // constructor injection

    protected $organization;

    public function __construct(
        OrganizationInterface $organizationInterface
    ) {
        $this->organization = $organizationInterface;
    }

    public function index(Request $request)
    {
        try {
            $data['title'] = ___('frontend.Institutes'); // title
            $search = $this->organization->model()->active();
            $data['instructors'] = [];
            $data['categories'] = [];
            $data['languages'] = [];
            $data['stateList'] = $search->clone()->select('state')
            ->groupBy('state')
            ->get()
            ->pluck('state');
            $data['cityList'] = $search->clone()->select('city')
            ->groupBy('city')
            ->get()
            ->pluck('city');
            return view('frontend.organization.organizations', compact('data')); // return success response from ApiReturnFormatTrait
        } catch (\Throwable $th) {
            return redirect()->route('home')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }
    
    public function filterInstitute(Request $req)
    {
        try {
            $data = [];
            $data['courses'] = $this->organization->filter($req)->paginate(10);
            $html = view('frontend.partials.render.institute_list', compact('data'))->render();
            $content = [
                'content' => $html,
                'total' => '<p class="page-total">' . ___('frontend.Showing') . ' <span class="text-tertiary">' . $data['courses']->lastItem() . '</span> ' . ___('frontend.of total') . ' <span class="text-tertiary">' . $data['courses']->total() . ' </span> ' . ___('course.Institutes') . ' </p>',
            ];
            return $this->responseWithSuccess(___('alert.data_retrieve_success'), $content); // return success response from ApiReturnFormatTrait

        } catch (\Throwable $th) {
            //dd($th);
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }

}