<?php

namespace App\Http\Controllers\Panel\Student;

use App\Enums\Role;
use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Events\UserEmailVerifyEvent;
use App\Http\Controllers\Controller;
use App\Traits\ApiReturnFormatTrait;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Modules\Student\Entities\Student;
use App\Http\Requests\frontend\student\SignUpRequest;
use Modules\Instructor\Entities\Instructor;
use Modules\Organization\Entities\Organization;
use Modules\Student\Entities\Referral;

class StudentAuthController extends Controller
{
    use ApiReturnFormatTrait;

    protected $user;
    protected $student;
    protected $instructor;
    protected $organization;

    public function __construct(User $user, Student $student,Instructor $instructor,Organization $organization)
    {
        $this->user = $user;
        $this->student = $student;
        $this->instructor = $instructor;
        $this->organization = $organization;

    }

    public function signUp($ref = '')
    {
        try {
            if (auth()->check()) {
                return redirect()->route('home')->with('warning', ___('alert.You are already logged in'));
            }
            $data['title'] = ___('student.Sign Up'); // title
            $data['referral'] = null;
            if ($ref) {
                $referral_exist = User::select('referral_code')->where('referral_code', $ref)->first();
                if ($referral_exist) {
                    $referral = $referral_exist->referral_code;
                    $data['referral'] = $referral;
                } else {
                    $data['referral'] = null;
                    // dd($data);

                }
            } else {
                $data['referral'] = null;
            }
            // dd($data);
            return view('frontend.auth.sign_up', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function signUpPost(SignUpRequest $request)
    {
        DB::beginTransaction(); // start database transaction
        // try {
            if (auth()->check()) {
                return redirect()->route('home')->with('warning', ___('alert.You are already logged in'));
            }
            $user_name = preg_replace('/[^A-Za-z0-9]/', '', Str::slug($request->name, '-'));
            $user = new $this->user;
            $user->name = $request->name;
            $user->username = $user_name . '-' . Str::random(5);
            $user->email = $request->email;
            $user->phone = $request->phone;
            $user->password = Hash::make($request->password);
            if ($request->user_type == 'institute') {
                $user->role_id = Role::ORGANIZATION;
                
                
            } elseif ($request->user_type == 'counsellor') {
                $user->role_id = Role::INSTRUCTOR;
                
            } else {
                $user->role_id = Role::STUDENT;
                
            }
            $user->status_id = 4;
            $user->referral_code = Str::random(8);
            
            //check if referral code exists
            

            if ($user->save()) {

            if ($request->user_type == 'institute') {
                $organization = $this->organization; // create new object of model for store data in database table
                $organization->user_id = $user->id;
                $organization->save();
            } elseif ($request->user_type == 'counsellor') {
                $instructor = $this->instructor; // create new object of model for store data in database table
                $instructor->user_id = $user->id;
                // dd($instructor);
                $instructor->save();
            } else {
                $user->student()->create();
            }


                if ($request->referral_code) {
                    $referral_exist = User::select('referral_code')->where('referral_code', $request->referral_code)->first();
                    if ($referral_exist) {
                        $referral_code = $request->referral_code;
                        //insert in referral table
                        Referral::create([
                            'reffered_by' => $referral_exist->id,
                            'user_id' => $user->id,
                            'referral_code' => $referral_code,
                            'used_at' => now(),
                        ]);

                        //add bonus to the user who referred
                        $referral_user = User::find($referral_exist->id);
                        $referral_user->balance += 100;
                        $referral_user->save();
                    } else {
                        return $this->responseWithError(___('alert.Referral code does not exist.'), [], 400);
                    }
                }

                
                // event(new UserEmailVerifyEvent($user));
                $data['redirect_url'] = route('frontend.signIn');
                // dd('here');
                // dd($user);
                DB::commit();
                return $this->responseWithSuccess(___('alert.'. $request->user_type.' has been Sign Up successfully.'), $data);
            }
        // } catch (\Throwable $th) {
        //     DB::rollBack(); // rollback database transaction
        //     return $this->responseWithError($th->getMessage(), [], 400); // return error response

        // }
    }
}
