<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AnswerLike extends Model
{
    use HasFactory;

    // Specify the table name
    protected $table = 'answer_likes';

    // Specify the fillable attributes
    protected $fillable = [
        'answer_id',
        'user_id',
        'is_like',
    ];

    /**
     * Get the answer that owns the like.
     */
    public function answer()
    {
        return $this->belongsTo(Answer::class);
    }

    /**
     * Get the user that owns the like.
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }
}