<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Organization\Entities\Organization;

class Inquiry extends Model
{
    use HasFactory;

    // Specify the table name
    protected $table = 'inquiries';

    // Specify the fillable attributes
    protected $fillable = [
        'organization_id',
        'name',
        'email',
        'phone',
        'message',
        'status_id',
        'stream_id',
        'course_id',
    ];

    /**
     * Get the organization that owns the inquiry.
     */
    public function organization()
    {
        return $this->belongsTo(Organization::class , 'organization_id');
    }

    //User
    public function user()
    {
        return $this->belongsTo('App\Models\User', 'organization_id');
    }

    //course relation
    public function course()
    {
        return $this->belongsTo('Modules\Course\Entities\Course');
    }

    //status relation
    public function status()
    {
        return $this->belongsTo('App\Models\Status');
    }
}
