<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TblQuestion extends Model
{
    use HasFactory;

    protected $table = 'tbl_questions';

    // Specify the fillable attributes
    protected $fillable = [
        'question',
        'user_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function answers()
    {
        return $this->hasMany(TblAnswer::class, 'question_id')->with('user');
    }
}
