$(function () {
    "use strict";

    var token = $('meta[name="csrf-token"]').attr("content");
    var main_url = $("#url").val();

    // ckeditor editor
    $(document).ready(function () {
        $(".ckeditor-editor").each(function (index, element) {
            ClassicEditor.create(element).then((editor) => {
                editor.model.document.on("change:data", () => {
                    var editorData = editor.getData();
                    $(element).val(editorData);
                });
            });
        });
    });

    // ckeditor editor

    window.submitForm = () => {
        const form = document.getElementById("modal_values");
        const url = form.getAttribute("action");
        const data = new FormData(form);
        $.ajax({
            url: url,
            type: "POST",
            data: data,
            processData: false,
            contentType: false,
            success: function (data) {
                if (data?.result) {
                    toaster.fire({
                        icon: "success",
                        title: data?.message,
                        time: 2000,
                    });
                    setTimeout(function () {
                        location.reload();
                    }, 2000);
                } else {
                    toaster.fire({
                        icon: "error",
                        title: something_went_wrong,
                    });
                }
            },
            error: function (error) {
                if (error?.responseJSON?.errors) {
                    $(".invalid-feedback").empty();
                    $.each(error?.responseJSON?.errors, function (key, value) {
                        $("#" + key).removeClass("is-invalid");
                        let file_error2 = $("#" + key)
                            .parent()
                            .parent()
                            .parent()
                            .find(".ot_fileUploader");
                        let file_error = $("#" + key)
                            .parent()
                            .parent()
                            .find(".ot_fileUploader");
                        let select2Tags = $("#" + key)
                            .next()
                            .find(".select2-selection");
                        let textareaTag = $("#" + key)
                            .next()
                            .find(".ck-editor");
                        if (
                            select2Tags?.prevObject[0]?.className ==
                            "select2 select2-container select2-container--default"
                        ) {
                            $("#" + key)
                                .next(".select2-container")
                                .next()
                                .empty();
                            $("#" + key)
                                .next(".select2-container")
                                .after(
                                    '<div class="invalid-feedback d-inline">' +
                                        value[0] +
                                        "</div>"
                                );
                        } else if (
                            textareaTag?.prevObject[0]?.className ==
                            "ck ck-reset ck-editor ck-rounded-corners"
                        ) {
                            $("#" + key)
                                .next()
                                .next()
                                .empty();
                            $("#" + key)
                                .next()
                                .after(
                                    '<div class="invalid-feedback d-inline">' +
                                        value[0] +
                                        "</div>"
                                );
                        } else if (
                            file_error2?.prevObject[0]?.className ==
                            "ot_fileUploader left-side mb-2 file-upload-browse"
                        ) {
                            $(".error-" + key).empty();
                            $(".error-" + key)
                                .next()
                                .empty();
                            $(".error-" + key).after(
                                '<div class="invalid-feedback d-inline">' +
                                    value[0] +
                                    "</div>"
                            );
                        } else if (
                            file_error?.prevObject[0]?.className ==
                            "ot_fileUploader left-side mb-2 file-upload-browse"
                        ) {
                            $(".error-" + key).empty();
                            $(".error-" + key)
                                .next()
                                .empty();
                            $(".error-" + key).after(
                                '<div class="invalid-feedback d-inline">' +
                                    value[0] +
                                    "</div>"
                            );
                        } else {
                            $("#" + key)
                                .next()
                                .empty();
                            $("#" + key).addClass("is-invalid");
                            $("#" + key).after(
                                '<div class="invalid-feedback">' +
                                    value[0] +
                                    "</div>"
                            );
                        }
                    });
                } else if (error?.responseJSON?.message) {
                    Toast.fire({
                        icon: "error",
                        title: error?.responseJSON?.message,
                    });
                }
            },
        });
    };
    console.clear();
    // Modal Select2 Dropdown
    $(".modal_select2").select2({
        dropdownParent: $(".modal-content"),
        width: "100%",
    });

    var hitModal_1 = true;
    window.submitMainForm = () => {
        if (!hitModal_1) {
            return false;
        }
        hitModal_1 = false;
        const form = document.getElementById("modal_values");
        const url = form.getAttribute("action");
        const data = new FormData(form);
        $.ajax({
            url: url,
            type: "POST",
            data: data,
            processData: false,
            contentType: false,
            success: function (data) {
                if (data?.result) {
                    toaster.fire({
                        icon: "success",
                        title: data?.message,
                        time: 2000,
                    });
                    modalClose();
                    setTimeout(function () {
                        location.reload();
                    }, 1500);
                } else {
                    hitModal_1 = true;
                    toaster.fire({
                        icon: "error",
                        title: something_went_wrong,
                    });
                }
            },
            error: function (error) {
                hitModal_1 = true;
                if (error?.responseJSON?.errors) {
                    $(".invalid-feedback").empty();
                    $.each(error?.responseJSON?.errors, function (key, value) {
                        $("#" + key).removeClass("is-invalid");
                        let file_error = $("#" + key)
                            .parent()
                            .parent()
                            .find(".ot_fileUploader");
                        let select2Tags = $("#" + key)
                            .next()
                            .find(".select2-selection");
                        let textareaTag = $("#" + key)
                            .next()
                            .find(".ck-editor");
                        let option = key.split(".");
                        if (
                            select2Tags?.prevObject[0]?.className ==
                            "select2 select2-container select2-container--default"
                        ) {
                            $("#" + key)
                                .next(".select2-container")
                                .next()
                                .empty();
                            $("#" + key)
                                .next(".select2-container")
                                .after(
                                    '<div class="invalid-feedback d-inline">' +
                                        value[0] +
                                        "</div>"
                                );
                        } else if (
                            textareaTag?.prevObject[0]?.className ==
                            "ck ck-reset ck-editor ck-rounded-corners"
                        ) {
                            $("#" + key)
                                .next()
                                .next()
                                .empty();
                            $("#" + key)
                                .next()
                                .after(
                                    '<div class="invalid-feedback d-inline">' +
                                        value[0] +
                                        "</div>"
                                );
                        } else if (option.length > 1) {
                            $("#options\\." + option[1])
                                .nextAll(".invalid-feedback")
                                .remove();
                            $("#options\\." + option[1])
                                .next()
                                .empty();
                            $("#options\\." + option[1]).addClass("is-invalid");
                            let errV = value[0].replace(key, "");
                            $("#options\\." + option[1]).after(
                                '<div class="invalid-feedback">' +
                                    errV +
                                    "</div>"
                            );
                        } else if (
                            file_error?.prevObject[0]?.className ==
                            "ot_fileUploader left-side mb-2"
                        ) {
                            $(".error-" + key).empty();
                            $(".error-" + key)
                                .next()
                                .empty();
                            $(".error-" + key).after(
                                '<div class="invalid-feedback d-inline">' +
                                    value[0] +
                                    "</div>"
                            );
                        } else {
                            $("#" + key)
                                .nextAll(".invalid-feedback")
                                .remove();
                            $("#" + key)
                                .next()
                                .empty();
                            $("#" + key).addClass("is-invalid");
                            $("#" + key).after(
                                '<div class="invalid-feedback">' +
                                    value[0] +
                                    "</div>"
                            );
                        }
                    });
                } else if (error?.responseJSON?.message) {
                    toaster.fire({
                        icon: "error",
                        title: error?.responseJSON?.message,
                    });
                }
            },
        });
    };

    // onclick browse by class name
    $(".file-upload-browse").on("change", function (event) {
        var fileName = event.target.files[0].name;
        $(this).find(".file_placeholder").attr("placeholder", fileName);
    });

    function divHide(className) {
        $("." + className).addClass("d-none");
        // with disable input , select amd textarea
        $("." + className)
            .find("input")
            .attr("disabled", true);
        $("." + className)
            .find("select")
            .attr("disabled", true);
        $("." + className)
            .find("textarea")
            .attr("disabled", true);
    }

    function divShow(className) {
        $("." + className).removeClass("d-none");
        // with enable input , select amd textarea
        $("." + className)
            .find("input")
            .attr("disabled", false);
        $("." + className)
            .find("select")
            .attr("disabled", false);
        $("." + className)
            .find("textarea")
            .attr("disabled", false);
    }

    let lessonType = "Youtube";
    window.lessonType = (val) => {
        lessonType = val.value;
        if (
            lessonType == "Youtube" ||
            lessonType == "Vimeo" ||
            lessonType == "GoogleDrive"
        ) {
            divShow("video_url"); // show video url
            divShow("video_duration"); // show video url
            divHide("video_file"); // hide video file
            divHide("document_file_type"); // hide document file type
            divHide("document_file"); // hide document file
            divHide("iframe_source"); // hide iframe source
            divHide("text_key"); // hide text_key
            divHide("image_file"); // hide image file
        } else if (lessonType == "VideoFile") {
            divHide("video_url"); // hide video url
            divShow("video_duration"); // show video file
            divShow("video_file"); // show video file
            divHide("document_file_type"); // hide document file type
            divHide("document_file"); // hide document file
            divHide("iframe_source"); // hide iframe source
            divHide("text_key"); // hide text_key
            divHide("image_file"); // hide image file
        } else if (lessonType == "ImageFile") {
            divHide("video_url"); // hide video url
            divHide("video_file"); // hide video file
            divHide("document_file_type"); // hide document file type
            divHide("document_file"); // hide document file
            divShow("image_file"); // show image file
            divHide("iframe_source"); // hide iframe source
            divHide("video_duration"); // hide iframe source
            divHide("text_key"); // hide iframe source
        } else if (lessonType == "Text") {
            divHide("video_url"); // hide video url
            divHide("video_file"); // hide video file
            divHide("document_file_type"); // hide document file type
            divHide("document_file"); // hide document file
            divHide("iframe_source"); // hide iframe source
            divHide("video_duration"); // hide iframe source
            divShow("text_key"); // show text_key
            divHide("image_file"); // hide image file
        } else if (lessonType == "IframeEmbed") {
            divHide("video_url"); // hide video url
            divHide("video_file"); // hide video file
            divHide("document_file_type"); // hide document file type
            divHide("document_file"); // hide document file
            divShow("iframe_source"); // show iframe source
            divHide("video_duration"); // show iframe source
            divHide("text_key"); // show iframe source
            divHide("image_file"); // hide image file
        } else {
            divHide("video_url"); // hide video url
            divHide("video_file"); // show video file
            divHide("video_duration"); // show video file
            divHide("text_key"); // show video file
            divHide("iframe_source"); // show iframe source
            divShow("document_file_type"); // show document file type
            divShow("document_file"); // show document file
            divHide("image_file"); // hide image file
        }
    };

    $(document).on("click", "#is_page", function () {
        if ($(this).is(":checked")) {
            divShow("page_url");
            divHide("custom_url");
        } else {
            divHide("page_url");
            divShow("custom_url");
        }
    });

    $(document).on("change", "#current", function () {
        let check = $(this);
        if (check.is(":checked")) {
            $(".end_date_div").addClass("d-none");
            $("#end_date").attr("disabled", true);
        } else {
            $(".end_date_div").removeClass("d-none");
            $("#end_date").attr("disabled", false);
        }
    });

    if ($("#skills").length > 0) {
        $("#skills").tagify({
            maxTags: 50,
            duplicates: false,
            autofocus: true,
        });
    }

    // select course start
    $(".course_list").select2({
        dropdownParent: $(".modal-content"),
        width: "100%",
        ajax: {
            url: $(".course_list").data("url"),
            dataType: "json",
            data: function (params) {
                return {
                    term: params.term,
                    _token: token,
                };
            },
            type: "POST",
            delay: 250,
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.text,
                            id: item.id,
                        };
                    }),
                };
            },
            cache: false,
        },
    });
    // Select course end

    // select  category start
    $(".course_category_list").select2({
        dropdownParent: $(".modal-content"),
        width: "100%",
        ajax: {
            url: $(".course_category_list").data("url"),
            dataType: "json",
            data: function (params) {
                return {
                    term: params.term,
                    _token: token,
                };
            },
            type: "POST",
            delay: 250,
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.text,
                            id: item.id,
                        };
                    }),
                };
            },
            cache: false,
        },
    });
    // Select course category end
});
$(document).on("click", ".submit_form_btn", function (e) {
    e.preventDefault();
    submitMainForm();
});

function addOptions() {
    var type = $("#type").find(":selected").val();
    var numOptions = $(".option_questions").val();
    var check_type = type == 1 ? "checkbox" : "radio";
    var options = "";
    for (var i = 0; i < numOptions; i++) {
        options += '<div class="ot-contact-form mb-24">';
        options += '<div class="input-group mb-2 mr-sm-2">';
        options += '<div class="input-group-prepend">';
        options += '<div class="input-group-text">';
        options += "<label>";
        options +=
            '<input class="ot-checkbox" type="' +
            check_type +
            '" value="' +
            i +
            '" id="answers.' +
            i +
            '" name="answers[]" />';
        options += '<span class="ot-checkmark"></span>';
        options += "</label>";
        options += "</div>";
        options += "</div>";
        options +=
            '<input type="text" id="options.' +
            i +
            '" name="options[]" class="form-control" required placeholder="Enter option ' +
            (i + 1) +
            '">';
        options += "</div>";
        options += "</div>";
    }
    $(".options_div").html(options);
}

$(document).on("keyup", ".option_questions", function (e) {
    addOptions();
});
$(document).on("change", ".change_question_type", function (e) {
    addOptions();
});
