

"use strict";
console.clear();
// ckeditor editor
$(document).ready(function() {

  $('.ckeditor-editor').each(function(index, element) {
    ClassicEditor.create(element)
      .then(editor => {
        editor.model.document.on('change:data', () => {
          var editorData = editor.getData();
           $(element).val(editorData)
        });
      });
  });

});

function tabDataLoad(){
  if(step == 2){
    courseAssignmentLoad();
  }else if(step == 3){
    courseNoticeBoardLoad();
  }

}


var modalClose = (event) => {
  $(".modal").remove();
  $(".modal-barkdrop").remove();
  $(".modal-backdrop").remove();
  $(".modal-open").removeClass("modal-open");
  $(".modal-backdrop").removeClass("modal-backdrop");
  $(".modal-backdrop").removeClass("modal-backdrop-open");
  $(".modal-backdrop").removeClass("show");
};
// ckeditor editor
var hitModal = true;
window.submitModalForm = () => {
  if (!hitModal) {
    return false;
  }
  hitModal = false;
  const form = document.getElementById("modal_values");
  const url = form.getAttribute("action");
  const data = new FormData(form);
  console.clear();
  $.ajax({
    url: url,
    type: "POST",
    data: data,
    processData: false,
    contentType: false,
    success: function (data) {
      if (data?.result) {
        successHandler(data?.message);
        tabDataLoad();
        modalClose();
      } else {
        hitModal = true;
        errorHandler(something_went_wrong);
      }
    },
    error: function (error) {
      hitModal = true;
      if (error?.responseJSON?.errors) {
        $('.invalid-feedback').empty();
        $.each(error?.responseJSON?.errors, function (key, value) {
            $('#' + key).removeClass('is-invalid');
            let file_error = $('#' + key).parent().parent().find('.ot_fileUploader');
            let select2Tags = $('#' + key).next().find('.select2-selection');
            let textareaTag = $('#' + key).next().find('.ck-editor');
            let option = key.split('.')
            if (select2Tags?.prevObject[0]?.className == 'select2 select2-container select2-container--default') {
                $('#' + key).next('.select2-container').next().empty();
                $('#' + key).next('.select2-container').after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
            }else if(textareaTag?.prevObject[0]?.className == 'ck ck-reset ck-editor ck-rounded-corners'){
                $('#' + key).next().next().empty();
                $('#' + key).next().after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
            }else if(option.length > 1 ){
              $('#options\\.'+option[1]).next().empty();
              $('#options\\.'+option[1]).addClass('is-invalid');
              $('#options\\.'+option[1]).after('<div class="invalid-feedback">' + value[0] + '</div>');
            }else if(file_error?.prevObject[0]?.className == 'ot_fileUploader left-side mb-2'){
                $('.error-'+key).empty();
                $('.error-' + key).next().empty();
                $('.error-'+key).after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
            }else{
                $('#' + key).next().empty();
                $('#' + key).addClass('is-invalid');
                $('#' + key).after('<div class="invalid-feedback">' + value[0] + '</div>');
            }
        });
    }else if(error?.responseJSON?.message) {
       errorHandler(error?.responseJSON?.message);
    }
    }
  });
}


var hitModal_1 = true;
window.submitMainForm = () => {
  if (!hitModal_1) {
    return false;
  }
  hitModal_1 = false;
  const form = document.getElementById("modal_values");
  const url = form.getAttribute("action");
  const data = new FormData(form);
  $.ajax({
    url: url,
    type: "POST",
    data: data,
    processData: false,
    contentType: false,
    success: function (data) {
      if (data?.result) {
        successHandler(data?.message);
        modalClose();
        setTimeout(function () {
        location.reload();
        }, 1500);
      } else {
        hitModal_1 = true;
        errorHandler(something_went_wrong);
      }
    },
    error: function (error) {
      hitModal_1 = true;
      if (error?.responseJSON?.errors) {
        $('.invalid-feedback').empty();
        $.each(error?.responseJSON?.errors, function (key, value) {
            $('#' + key).removeClass('is-invalid');
            let file_error = $('#' + key).parent().parent().find('.ot_fileUploader');
            let select2Tags = $('#' + key).next().find('.select2-selection');
            let textareaTag = $('#' + key).next().find('.ck-editor');
            let option = key.split('.')
            if (select2Tags?.prevObject[0]?.className == 'select2 select2-container select2-container--default') {
                $('#' + key).next('.select2-container').next().empty();
                $('#' + key).next('.select2-container').after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
            }else if(textareaTag?.prevObject[0]?.className == 'ck ck-reset ck-editor ck-rounded-corners'){
                $('#' + key).next().next().empty();
                $('#' + key).next().after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
            }else if(option.length > 1 ){
                $('#options\\.'+option[1]).nextAll('.invalid-feedback').remove();
                $('#options\\.'+option[1]).next().empty();
                $('#options\\.'+option[1]).addClass('is-invalid');
                let errV = value[0].replace(key, '');
                $('#options\\.'+option[1]).after('<div class="invalid-feedback">' + errV + '</div>');
            }else if(file_error?.prevObject[0]?.className == 'ot_fileUploader left-side mb-2'){
                $('.error-'+key).empty();
                $('.error-' + key).next().empty();
                $('.error-'+key).after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
            }else{
                $('#' + key).nextAll('.invalid-feedback').remove();
                $('#' + key).next().empty();
                $('#' + key).addClass('is-invalid');
                $('#' + key).after('<div class="invalid-feedback">' + value[0] + '</div>');
            }
        });
    }else if(error?.responseJSON?.message) {
       errorHandler(error?.responseJSON?.message);
    }
    }
  });
}
// Modal Select2 Dropdown
$('.modal_select2').select2({
  dropdownParent: $(".modal-content"),
  width: "100%",
});

$('.modal_values').on('submit', function(e) {
  e.preventDefault();
  submitMainForm();
});

$(document).on('click', '.submit_form', function(e) {
  e.preventDefault();
  submitModalForm();
});
$(document).on('click', '.submit_form_btn', function(e) {
  e.preventDefault();
  submitMainForm();
});

// onclick browse by class name
$('.ot_fileUploader').on('change', function(event) {
  var fileName = event.target.files[0].name;
  $(this).find('.file_placeholder').attr('placeholder', fileName);
});


// datepicker
$('.datePicker').each(function() {
  $(this).daterangepicker({
    singleDatePicker: true,
    showDropdowns: true
  });
});
// datepicker

$(document).on('change', '#current', function() {
let check = $(this);
if (check.is(':checked')) {
  $('.end_date_div').addClass('d-none');
  $('#end_date').attr('disabled', true);
} else {
  $('.end_date_div').removeClass('d-none');
  $('#end_date').attr('disabled', false);
}
});


jQuery(document).ready(function(){
jQuery('input').keypress(function(event){
    var enterOkClass =  jQuery(this).attr('class');
    if (event.which == 13 && enterOkClass != 'enterSubmit') {
        event.preventDefault();
        return false;
    }
});
});

$('#skills').tagify({
  maxTags : 50,
  duplicates : false,
  autofocus : true,
});

$(document).on('click', '.close-modal', function(e) {
  e.preventDefault();
  modalClose();
});


function divHide(className) {
  $('.'+className).addClass('d-none');
  // with disable input , select amd textarea
  $('.'+className).find('input').attr('disabled', true);
  $('.'+className).find('select').attr('disabled', true);
  $('.'+className).find('textarea').attr('disabled', true);
}

function divShow(className) {
  $('.'+className).removeClass('d-none');
  // with enable input , select amd textarea
  $('.'+className).find('input').attr('disabled', false);
  $('.'+className).find('select').attr('disabled', false);
  $('.'+className).find('textarea').attr('disabled', false);
}

var lessonType = 'Youtube';

function lessonTypeFunction(val){
  lessonType = val;
  if(lessonType == 'Youtube' || lessonType == 'Vimeo' || lessonType == 'GoogleDrive'){
    divShow('video_url'); // show video url
    divShow('video_duration'); // show video url
    divHide('video_file'); // hide video file
    divHide('document_file_type'); // hide document file type
    divHide('document_file'); // hide document file
    divHide('iframe_source'); // hide iframe source
    divHide('text_key'); // hide text_key
    divHide('image_file'); // hide image file
  }else if(lessonType == 'VideoFile'){
    divHide('video_url'); // hide video url
    divShow('video_duration'); // show video file
    divShow('video_file'); // show video file
    divHide('document_file_type'); // hide document file type
    divHide('document_file'); // hide document file
    divHide('iframe_source'); // hide iframe source
    divHide('text_key'); // hide text_key
    divHide('image_file'); // hide image file
  }else if(lessonType == 'ImageFile'){
    divHide('video_url'); // hide video url
    divHide('video_file'); // hide video file
    divHide('document_file_type'); // hide document file type
    divHide('document_file'); // hide document file
    divShow('image_file'); // show image file
    divHide('iframe_source'); // hide iframe source
    divHide('video_duration'); // hide iframe source
    divHide('text_key'); // hide iframe source
  }else if(lessonType == 'Text'){
    divHide('video_url'); // hide video url
    divHide('video_file'); // hide video file
    divHide('document_file_type'); // hide document file type
    divHide('document_file'); // hide document file
    divHide('iframe_source'); // hide iframe source
    divHide('video_duration'); // hide iframe source
    divShow('text_key'); // show text_key
    divHide('image_file'); // hide image file
  }else if(lessonType == 'IframeEmbed'){
    divHide('video_url'); // hide video url
    divHide('video_file'); // hide video file
    divHide('document_file_type'); // hide document file type
    divHide('document_file'); // hide document file
    divShow('iframe_source'); // show iframe source
    divHide('video_duration'); // show iframe source
    divHide('text_key'); // show iframe source
    divHide('image_file'); // hide image file
  }else{
    divHide('video_url'); // hide video url
    divHide('video_file'); // show video file
    divHide('video_duration'); // show video file
    divHide('text_key'); // show video file
    divHide('iframe_source'); // show iframe source
    divShow('document_file_type'); // show document file type
    divShow('document_file'); // show document file
    divHide('image_file'); // hide image file
  }
}

$(document).on('change', '#lesson_type', function(e) {
  lessonTypeFunction($(this).val());
});

function IsTime(){
  var is_timer = $('#is_timer').is(':checked');
  if(is_timer) {
    divHide('video_duration');
  }else{
    divShow('video_duration');
  }
}

function quizOrLesson(val){

  if(val == '1'){
    divShow('quiz_div');
    divShow('video_duration');
    divHide('lesson_div');
    IsTime();
  }else{
    divShow('lesson_div');
    divHide('quiz_div');
    lessonTypeFunction(lessonType);
  }
}

$(document).on('change', '#is_quiz', function(e) {
  quizOrLesson($(this).val());
});


$('#is_timer').on('click', function() {
  IsTime();
});

$(document).ready(function(){
  var is_quiz = $('#is_quiz').find(':selected').val();
  is_quiz && quizOrLesson(is_quiz);
});


// start submit form assignment
$(document).on('click', '.assignment_submit', function(e) {
  e.preventDefault();
  submitModalForm();
});
// end submit form assignment
// start submit form assignment
$(document).on('click', '.submit_form_tab_modal', function(e) {
  e.preventDefault();
  submitModalForm();
});
// end submit form assignment

function addOptions(){
  var type = $('#type').find(':selected').val();
  var numOptions = $('.option_questions').val();
  var check_type = type == 1 ? 'checkbox' : 'radio';
  var options = '';
  for (var i = 0; i < numOptions; i++) {

    options += '<div class="ot-contact-form mb-24">';
    options += '<div class="input-group mb-2 mr-sm-2">';
    options += '<div class="input-group-prepend">';
    options += '<div class="input-group-text">';
    options += '<label>';
    options += '<input class="ot-checkbox" type="'+check_type+'" value="'+i+'" id="answers.'+i+'" name="answers[]" />';
    options += '<span class="ot-checkmark"></span>';
    options += '</label>';
    options += '</div>';
    options += '</div>';
    options += '<input type="text" id="options.'+i+'" name="options[]" class="form-control" required placeholder="option '+ (i+1) +'">';
    options += '</div>';
    options += '</div>';



  }
  $('.options_div').html(options);
}

$(document).on('keyup', '.option_questions', function(e) {
  addOptions();

});
$(document).on('change', '.change_question_type', function(e) {
  addOptions();
});

function paymentMethod(){
  var payment_method = $('#payment_method').find(':selected').val();
  if(payment_method == 1 ){
    divHide('paypal_div');
    divHide('sslcommerz_div');
    divShow('stripe_div');
  }else{
    divHide('stripe_div');
    divHide('paypal_div');
    divShow('sslcommerz_div');
  }
}

$(document).on('change', '#payment_method', function(e) {
  paymentMethod();
});
$('#payment_method').length && paymentMethod();




