

  "use strict";
  console.clear();

  // ckeditor editor
  $(document).ready(function() {
    $('.ckeditor-editor').each(function(index, element) {
      ClassicEditor.create(element)
        .then(editor => {
          editor.model.document.on('change:data', () => {
            var editorData = editor.getData();
             $(element).val(editorData)
          });
        });
    });
  });


  var modalClose = (event) => {
    $(".modal").remove();
    $(".modal-barkdrop").remove();
    $(".modal-backdrop").remove();
    $(".modal-open").removeClass("modal-open");
    $(".modal-backdrop").removeClass("modal-backdrop");
    $(".modal-backdrop").removeClass("modal-backdrop-open");
    $(".modal-backdrop").removeClass("show");
  };
  // ckeditor editor

  window.submitForm = () => {
    const form = document.getElementById("modal_values");
    const url = form.getAttribute("action");
    const data = new FormData(form);
    $.ajax({
      url: url,
      type: "POST",
      data: data,
      processData: false,
      contentType: false,
      success: function (data) {
        if (data?.result) {
          successHandler(data?.message);
          tabLoad('Notes');
          modalClose();
        } else {
          errorHandler(something_went_wrong);
        }
      },
      error: function (error) {
        if (error?.responseJSON?.errors) {
          $('.invalid-feedback').empty();
          $.each(error?.responseJSON?.errors, function (key, value) {
              $('#' + key).removeClass('is-invalid');
              let file_error = $('#' + key).parent().parent().find('.ot_fileUploader');
              let select2Tags = $('#' + key).next().find('.select2-selection');
              let textareaTag = $('#' + key).next().find('.ck-editor');
              if (select2Tags?.prevObject[0]?.className == 'select2 select2-container select2-container--default') {
                  $('#' + key).next('.select2-container').next().empty();
                  $('#' + key).next('.select2-container').after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
              }else if(textareaTag?.prevObject[0]?.className == 'ck ck-reset ck-editor ck-rounded-corners'){
                  $('#' + key).next().next().empty();
                  $('#' + key).next().after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
              }else if(file_error?.prevObject[0]?.className == 'ot_fileUploader left-side mb-2 file-upload-browse'){
                  $('.error-'+key).empty();
                  $('.error-' + key).next().empty();
                  $('.error-'+key).after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
              }else{
                  $('#' + key).next().empty();
                  $('#' + key).addClass('is-invalid');
                  $('#' + key).after('<div class="invalid-feedback">' + value[0] + '</div>');
              }
          });
      }else if(error?.responseJSON?.message) {
         errorHandler(error?.responseJSON?.message);
      }
      }
    });
  }
  window.submitMainForm = () => {
    const form = document.getElementById("modal_values");
    const url = form.getAttribute("action");
    const data = new FormData(form);
    $.ajax({
      url: url,
      type: "POST",
      data: data,
      processData: false,
      contentType: false,
      success: function (data) {
        if (data?.result) {
          successHandler(data?.message);
          modalClose();
          setTimeout(function () {
          location.reload();
          }, 1500);
        } else {
          errorHandler(something_went_wrong);
        }
      },
      error: function (error) {
        if (error?.responseJSON?.errors) {

            $('.invalid-feedback').empty();
            $.each(error?.responseJSON?.errors, function (key, value) {
                $('#' + key).removeClass('is-invalid');
                let file_error = $('#' + key).parent().parent().find('.ot_fileUploader');
                let select2Tags = $('#' + key).next().find('.select2-selection');
                let textareaTag = $('#' + key).next().find('.ck-editor');
                let summerNote = $('#' + key).next().find(".note-editor");
              if (select2Tags?.prevObject[0]?.className == 'select2 select2-container select2-container--default') {
                  $('#' + key).next('.select2-container').next().empty();
                  $('#' + key).next('.select2-container').after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
              }else if(textareaTag?.prevObject[0]?.className == 'ck ck-reset ck-editor ck-rounded-corners'){
                  $('#' + key).next().next().empty();
                  $('#' + key).next().after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
              }else if(file_error?.prevObject[0]?.className == 'ot_fileUploader left-side mb-24 file-upload-browse'){
                  $('.error-'+key).empty();
                  $('.error-' + key).next().empty();
                  $('.error-'+key).after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
              }else if(summerNote?.prevObject[0]?.className == 'note-editor note-frame'){
                $('#' + key).next().next().empty();
                $('#' + key).next().after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
              }else if(file_error?.prevObject[0]?.className == 'ot_fileUploader left-side mb-2 file-upload-browse'){
                  $('.error-'+key).empty();
                  $('.error-' + key).next().empty();
                  $('.error-'+key).after('<div class="invalid-feedback d-inline">' + value[0] + '</div>');
              }else{
                  $('#' + key).next().empty();
                  $('#' + key).addClass('is-invalid');
                  $('#' + key).after('<div class="invalid-feedback">' + value[0] + '</div>');
              }
          });
      }else if(error?.responseJSON?.message) {
         errorHandler(error?.responseJSON?.message);
      }
      }
    });
  }
// Modal Select2 Dropdown
$('.modal_select2').select2({
    dropdownParent: $(".modal-content"),
    width: "100%",
});

$('.modal_values').on('submit', function(e) {
  e.preventDefault();
  submitForm();
});


 $('#schedule_call_date').on('change', function() {
   var selectedDate = new Date($(this).val());
            var days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
            var selectedDay = days[selectedDate.getUTCDay()];

            $('.day-slots').each(function() {
                if ($(this).data('day') === selectedDay) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });

 // onclick browse by class name
$('.file-upload-browse').on('change', function(event) {
  var fileName = event.target.files[0].name;
  $(this).find('.file_placeholder').attr('placeholder', fileName);
});

// start rating

$('#stars i').on('mouseover', function(){
  var onStar = parseInt($(this).data('value'), 10);
  $(this).parent().children('i.make_rating').each(function(e){
    if (e < onStar) {
      // $(this).addClass('hover');
    }
    else {
      // $(this).removeClass('hover');
    }
  });

}).on('mouseout', function(){
  $(this).parent().children('i.make_rating').each(function(e){
    // $(this).removeClass('hover');
  });
});

$(document).on('click', '.make_rating', function(e) {
  var onStar = parseInt($(this).data('value'), 10);
  $(this).parent().children('i.make_rating').each(function(e){
    if (e < onStar) {
      $(this).addClass('text-yellow');
    }
    else {
      $(this).removeClass('text-yellow');
    }
  });
  $('#ratingVal').val(onStar);

});

// datepicker
$('.datePicker').each(function() {
  $(this).daterangepicker({
    singleDatePicker: true,
    showDropdowns: true
  });
});
// datepicker

$(document).on('change', '#current', function() {
  let check = $(this);
  if (check.is(':checked')) {
    $('.end_date_div').addClass('d-none');
    $('#end_date').attr('disabled', true);
  } else {
    $('.end_date_div').removeClass('d-none');
    $('#end_date').attr('disabled', false);
  }
});


jQuery(document).ready(function(){
  jQuery('input').keypress(function(event){
      var enterOkClass =  jQuery(this).attr('class');
      if (event.which == 13 && enterOkClass != 'enterSubmit') {
          event.preventDefault();
          return false;
      }
  });
});

$('#skills').tagify({
  maxTags : 50,
  duplicates : false,
  autofocus : true,

});

$(document).on('click', '.close-modal', function(e) {
  e.preventDefault();
  modalClose();
});

var options =  {
    blockquoteBreakingLevel: 2,
    disableDragAndDrop: true,
    toolbar: [
        ['style', ['bold', 'italic', 'underline', 'clear']],
        ['font', ['strikethrough', 'superscript', 'subscript','fontname']],
        ['fontsize', ['fontsize']],
        ['color', ['color']],
        ['para', ['ul', 'ol', 'paragraph']],
        ['insert',['ltr','rtl']],
        ['insert', ['link','picture', 'video', 'hr']],
        ['table', ['table']],
        ['air', ['undo', 'redo']],
        ['view', ['codeview']]
    ]
  };

$(document).ready(function() {
    $('.summernote').length > 0 && $('.summernote').summernote(options);

});



