@extends('backend.master')

@section('title')
    {{ ___('common.Dashboard') }}
@endsection

@push('css')
    {{-- Chart js --}}
    <link rel="stylesheet" href="{{ asset('backend') }}/assets/css/apexcharts.min.css">
@endpush

@section('content')
    <div class="page-content">
        <div class="row g-4">

            <!-- Welcome Title -->
           

            <!-- Dashboard Summery Card Start -->
         
           

            <div class="col-xxl-12 col-xl-12 ">
                <div class="ot-card chart-card2 h-calc">

                    {{-- Tittle --}}
                    <div class="card-header d-flex justify-content-between">
                        <div class="card-title">
                            <h4>{{ ___('dashboard.Sales') }}</h4>
                        </div>
                    </div>

                    {{-- Chart --}}
                    <div id="sales_chart" class=""></div>
                </div>
            </div>

          
            {{-- Table --}}


            <!--  top five student start -->
            <div class="col-lg-6 table-content table-basic">
                <div class="card h-calc">
                    <div class="card-body">
                        <div class="card-title mb-20">
                            <h4>{{ ___('dashboard.Top_Five_Students') }}</h4>
                        </div>

                        <div class="table-responsive table-height-350 niceScroll">
                            <table class="table table-bordered">
                                <thead class="thead">
                                    <tr>
                                        <th class="serial">{{ ___('common.ID.') }}</th>
                                        <th class="purchase">{{ ___('common.name') }}</th>
                                        <th class="purchase">{{ ___('student.Enroll') }}</th>
                                        <th class="purchase">{{ ___('student.Point') }}</th>
                                        <th class="purchase">{{ ___('common.status') }}</th>
                                    </tr>
                                </thead>
                                <tbody class="tbody">
                                    @forelse ($data['top_students'] as $key => $student)
                                        <tr>
                                            <td>{{ ++$key }}</td>
                                            <td>
                                                {{ @$student->user->name }}
                                            </td>
                                            <td>{{ @$student->points }}</td>
                                            <td>{{ @$student->enrollments->count() }}</td>
                                            <td>
                                                @if (@$student->user->status == App\Enums\Status::ACTIVE)
                                                    <span
                                                        class="badge-basic-success-text">{{ ___('common.Active') }}</span>
                                                @else
                                                    <span
                                                        class="badge-basic-danger-text">{{ ___('common.Inactive') }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <!-- empty table -->
                                        @include('backend.ui-components.empty_table', [
                                            'colspan' => '5',
                                            'message' => ___(
                                                'message.Please add a new entity or manage the data table to see the content here'),
                                        ])
                                        <!-- empty table -->
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <!--  table end -->
                    </div>
                </div>
            </div>
            <!--  top five student end -->

            <!--  top five instructor start -->
            <div class="col-lg-6 table-content table-basic">
                <div class="card h-calc">
                    <div class="card-body">
                        <div class="card-title mb-20">
                            <h4>{{ ___('dashboard.Top_Five_Instructors') }}</h4>
                        </div>

                        <div class="table-responsive table-height-350 niceScroll">
                            <table class="table table-bordered">
                                <thead class="thead">
                                    <tr>
                                        <th class="serial">{{ ___('common.ID.') }}</th>
                                        <th class="purchase">{{ ___('common.name') }}</th>
                                        <th class="purchase">{{ ___('course.Courses') }}</th>
                                        <th class="purchase">{{ ___('common.Sales') }}</th>
                                        <th class="purchase">{{ ___('common.status') }}</th>
                                    </tr>
                                </thead>
                                <tbody class="tbody">
                                    @forelse ($data['top_instructors'] as $key => $instructor)
                                        <tr>
                                            <td>{{ ++$key }}</td>
                                            <td>
                                                {{ @$instructor->user->name }}
                                            </td>
                                            <td>{{ @$instructor->courses->count() }}</td>
                                            <td>{{ @$instructor->user->courseEnroll ? @$instructor->user->courseEnroll->count() : 0 }}</td>
                                            <td>
                                                @if (@$instructor->user->status == App\Enums\Status::ACTIVE)
                                                    <span
                                                        class="badge-basic-success-text">{{ ___('common.Active') }}</span>
                                                @else
                                                    <span
                                                        class="badge-basic-danger-text">{{ ___('common.Inactive') }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @empty
                                        <!-- empty table -->
                                        @include('backend.ui-components.empty_table', [
                                            'colspan' => '5',
                                            'message' => ___(
                                                'message.Please add a new entity or manage the data table to see the content here'),
                                        ])
                                        <!-- empty table -->
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        <!--  table end -->
                    </div>
                </div>
            </div>
            <!--  top five instructor end -->


        </div>
        <!-- table leave container end -->
    </div>
@endsection

@push('script')
    <script src="{{ asset('backend') }}/vendors/apexchart/js/apexcharts.min.js"></script>
    <script src="{{ asset('backend') }}/assets/js/apex-chart.js"></script>
@endpush
