<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="updated_frontend/css/home/login.css">
</head>
<body>
@extends('frontend.layouts.master')
@section('title', @$data['title'])
@section('content')

    <div class="about-new">
      <section class="aboutBanner">
        <div class="banner">
          <img src="{{asset('/updated_frontend/images/university/img-1.jpg')}}" alt="">
        </div>
        <div class="container">
          <div class="aboutUs col-lg-12 text-center pt-5">
            <h3 class="mb-3">About Eduroutez</h3>
            <p class="">About <a href="">Eduroutez.com</a> Welcome to Eduroutez.com, your comprehensive search engine dedicated to empowering students, parents, counselors, instructors, and education industry players in navigating the higher education sector, both in India and abroad. At Eduroutez, we understand the critical role education plays in shaping individuals' futures and believe that access to accurate and relevant information is key to making informed decisions.</p>
            <p>
            At <a href="">Eduroutez.com</a>, we understand the importance of choosing the right college. That's why we offer a wide range of services aimed at assisting students in finding the perfect fit for their academic and career goals. Whether you're looking for information about admission requirements, programs offered, campus facilities, or student life, we have you covered.
            </p>
            <p>
            Our platform is designed to be user-friendly and intuitive, making it easy for students to navigate and explore various colleges effortlessly. We strive to keep our database up-to-date with the latest information so that students can rely on us for accurate and reliable insights.
            </p>
            <p>
            With <a href="">Eduroutez.com</a>, you can access valuable resources and tools to aid you in your college search journey. Our goal is to empower students with the knowledge and resources they need to make informed decisions and embark on a successful academic path.
            </p>
            <p>
            Thank you for choosing <a href="">Eduroutez.com</a> as your trusted partner in the college search process. We look forward to helping you navigate the exciting world of higher education!
            </p>
          </div>
        </div>
      </section>
      
      <!-- Start Our mission -->
      <section class="ourMission pt-5">
        <div class="container">
          <div class="row mission">
            <div class="col-lg-6 col-md-6 col-xl-6 col-12">
              <div class="mission-info">
                <h3 class="text-center pb-2">Our Mission</h3>
                <p>At Eduroutez.com, our mission is to empower students by offering comprehensive college listings and providing accurate and up-to-date information about colleges and universities. We strive to be a reliable source for students in their academic journey, assisting them in making informed decisions about their education.</p>
              </div>
            </div>
            <div class="col-lg-6 col-md-6 col-xl-6 col-12 mb-3">
              <img src="{{asset('/updated_frontend/images/about/Mission.jpg')}}" alt="">
            </div>
          </div>
          <div class="row mission">
          <div class="col-lg-6 col-md-6 col-xl-6 col-12 order1">
              <div class="mission-info">
                <h3 class="text-center pb-2">Our Vision</h3>
                <p>Our vision at Eduroutez.com is to become the go-to platform for students seeking college information and guidance. We aim to create a seamless experience for students, where they can easily access relevant details about various colleges and make choices that align with their academic and career aspirations. Through our platform, we envision bridging the gap between students and educational institutions, facilitating a smoother transition into higher education.</p>
              </div>
            </div>
            <div class="col-lg-6 col-md-6 col-xl-6 col-12 order2">
              <img src="{{asset('/updated_frontend/images/about/Vision.jpg')}}" alt="">
            </div>
            
          </div>
        </div>
      </section>
      <!-- End Our mission -->
      
      <!-- Start Our Team -->
      <section class="outTeam pt-5 pb-5">
        <div class="container">
          <h3 class="mb-3">What do we offer</h3>
          <div class="row box mb-4">
            <div class="col-lg-4 col-md-4 col-12">
              <img src="{{asset('/updated_frontend/images/about/Student-img.jpg')}}" alt="">
            </div>
            <div class="col-lg-8 col-md-8 col-12">
              <h5 class="team-title">Students</h5>
              <p class="team-desc">Eduroutez.com is designed to assist students at every stage of their academic endeavors. From researching colleges and courses to understanding admission processes and eligibility criteria, our platform provides the necessary resources to help students make informed decisions about their education.</p>
            </div>   
          </div>
          <div class="row box mb-4">
            <div class="col-lg-4 col-md-4 order1">
              <img src="{{asset('/updated_frontend/images/about/College-Image.jpg')}}" alt="">
            </div>
            <div class="col-lg-8 col-md-8 order2">
              <h5 class="team-title">Colleges / Institutes</h5>
              <p class="team-desc">A repository of over 25,000 colleges and 6,000 courses across various streams like Management, Engineering, Medical, and Arts, the website simplifies the process of searching for your alma mater. You can filter colleges based on location, rankings, ratings, fees, and cutoffs for different competitive exams.</p>
            </div>   
          </div>
          <div class="row box mb-4">
            <div class="col-lg-4 col-md-4">
              <img src="{{asset('/updated_frontend/images/about/University-Image.jpg')}}" alt="">
            </div>
            <div class="col-lg-8 col-md-8 ">
              <h5 class="team-title">Universities</h5>
              <p class="team-desc">"eduroutez.com" is a platform providing university details for students, it likely offers information such as university rankings, admission requirements, programs offered, campus facilities, student reviews, and possibly tools to help students in their academic journey.</p>
            </div>   
          </div>
          <div class="row box mb-4">
            <div class="col-lg-4 col-md-4 order1">
              <img src="{{asset('/updated_frontend/images/about/Counselling-Image.jpg')}}" alt="">
            </div>
            <div class="col-lg-8 col-md-8 order2">
              <h5 class="team-title">Counselling</h5>
              <p class="team-desc">Eduroutez is an innovative educational platform dedicated to empowering students through comprehensive guidance and academic answers. As a counselor on Eduroutez, your role is crucial in supporting students on their educational path, providing them with the necessary information and assistance to thrive.</p>
            </div>   
          </div>
          <div class="row box mb-4">
            <div class="col-lg-4 col-md-4">
              <img src="{{asset('/updated_frontend/images/about/Educationist.jpg')}}" alt="">
            </div>
            <div class="col-lg-8 col-md-8">
              <h5 class="team-title">Educationist</h5>
              <p class="team-desc">Eduroutez embraces the transformative potential of education for both students and instructors. We recognize the pivotal role educators play in shaping learning experiences. To enhance their skills, we conduct seminars aimed at empowering, inspiring, and equipping them with cutting-edge tools and teaching methodologies.</p>
            </div>   
          </div>
        </div>
            <!-- <div class="col  mb-3">
              <div class="row box">
                <div class="col-lg-3 col-md-3">
                <img src="{{asset('/updated_frontend/images/university/img-1.jpg')}}" alt="">
                </div>
                <div class="col-lg-9 col-md-9  ">
                <h5 class="team-title">Colleges / Institutes</h5>
                <p class="team-desc">Students can use <a href="">Eduroutez.com</a> as one stop destination to search about their dream college, available courses, admission process and lots more interactive tools to simplify the process of finding alma-mater. The website has the repository of more than 25,000 colleges and 6000 courses categorized in different streams like Management, Engineering, Medical, Arts and much more. One can classify colleges on the basis of location, ranking, ratings, fees and cutoff for different competitive exams</p>
                </div>
              </div>
            </div>
            <div class="col  mb-3">
              <div class="row box">
                <div class="col-lg-3 col-md-3">
                <img src="{{asset('/updated_frontend/images/university/img-1.jpg')}}" alt="">
                </div>
                <div class="col-lg-9 col-md-9  ">
                <h5 class="team-title">Universities </h5>
                <p class="team-desc">Students can use <a href="">Eduroutez.com</a> as one stop destination to search about their dream college, available courses, admission process and lots more interactive tools to simplify the process of finding alma-mater. The website has the repository of more than 25,000 colleges and 6000 courses categorized in different streams like Management, Engineering, Medical, Arts and much more. One can classify colleges on the basis of location, ranking, ratings, fees and cutoff for different competitive exams</p>
                </div>
              </div>
            </div>
            <div class="col  mb-3">
              <div class="row box">
                <div class="col-lg-3 col-md-3">
                <img src="{{asset('/updated_frontend/images/university/img-1.jpg')}}" alt="">
                </div>
                <div class="col-lg-9 col-md-9  ">
                <h5 class="team-title">Counselling</h5>
                <p class="team-desc">Students can use <a href="">Eduroutez.com</a> as one stop destination to search about their dream college, available courses, admission process and lots more interactive tools to simplify the process of finding alma-mater. The website has the repository of more than 25,000 colleges and 6000 courses categorized in different streams like Management, Engineering, Medical, Arts and much more. One can classify colleges on the basis of location, ranking, ratings, fees and cutoff for different competitive exams</p>
                </div>
              </div>
            </div>
            <div class="col  mb-3 endTeam">
              <div class="row box">
                <div class="col-lg-3 col-md-3">
                <img src="{{asset('/updated_frontend/images/university/img-1.jpg')}}" alt="">
                </div>
                <div class="col-lg-9 col-md-9  ">
                <h5 class="team-title">Educationiest</h5>
                <p class="team-desc">Students can use <a href="">Eduroutez.com</a> as one stop destination to search about their dream college, available courses, admission process and lots more interactive tools to simplify the process of finding alma-mater. The website has the repository of more than 25,000 colleges and 6000 courses categorized in different streams like Management, Engineering, Medical, Arts and much more. One can classify colleges on the basis of location, ranking, ratings, fees and cutoff for different competitive exams</p>
                </div>
              </div>
            </div> -->
    </section>
    <!-- End Our Team -->
    </div>
  </div>

    

    
    @endsection

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
