<div class="modal fade boostrap-modal" aria-labelledby="modalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content data">

            <div class="modal-body">
                <button type="button" class="close-icon" data-bs-dismiss="modal" aria-label="Close">
                    <i class="ri-close-line" aria-hidden="true"></i>
                </button>
                <div class="custom-modal-body ">
                    <form action="{{ @$data['url'] }}" method="post" id="modal_values" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="instructor_id" value="{{ $data['instructor']->id }}">
                        <!-- Title -->
                        <div class="small-tittle-two border-bottom mb-30 pb-8">
                            <h4 class="title text-capitalize font-600">{{ $data['title'] }} </h4>
                        </div>

                        <div class="ot-contact-form mb-24">
                            <label class="ot-contact-label">{{ ___('student.Schedule Call Date') }}
                                <span class="text-danger">*</span></label>
                            <input class="form-control ot-contact-input datePicker" type="text" name="schedule_call_date" id="schedule_call_date">
                        </div>
                        <div class="ot-contact-form mb-24">
                            <label class="ot-contact-label">{{ ___('student.Time Slots') }}
                                <span class="text-danger">*</span></label>
                            <div class="row">

                                @foreach(['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'] as $day)
                                <div class="col-md-12 row day-slots" data-day="{{ $day }}" >
                                    <h4>{{ $day }}</h4>
                                    @foreach($data['slots']->where('day', $day) as $slot)
                                    <div class="col-md-3">
                                        <div class="input-check-radio">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="call_time" value="{{ $slot->start_time }}" id="time-{{ $slot->id }}">
                                                <label class="form-check-label" for="time-{{ $slot->id }}">{{ $slot->start_time }}</label>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                                @endforeach

                              
                            </div>
                        </div>
                        <!-- Submit button -->
                        <div class="btn-wrapper d-flex flex-wrap gap-15 mt-20">
                            <button class="btn-primary-fill" type="submit">{{ @$data['button'] }}</button>
                            <button class="btn-primary-outline close-modal" type="button">{{ ___('student.Discard') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="{{ asset('frontend/js/student/__modal.min.js') }}"></script>