@extends('panel.student.layouts.master')
@section('title', @$data['title'])
@section('content')
<!-- Courses -->
<section>
    <div class="row">
        <!-- Section Tittle -->
        <div class="col-xl-12">
            <div class="section-tittle-two border-bottom d-flex align-items-center justify-content-between flex-wrap mb-10 pb-20 gap-15">
                <h2 class="title font-600">{{ $data['title'] }}</h2>
                <div class="right d-flex flex-wrap justify-content-between">
                    <!-- Search Box -->

                    <!-- /End -->
                </div>
            </div>
        </div>

        <!-- Search -->
    </div>

    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h3>{{ __('common.Refer and Earn') }}</h3>
                    <p>{{ __('common.Share your referral link and earn rewards!') }}</p>
                    <div class="referral-link">
                        <input type="text" class="form-control" value="{{ $data['referralLink'] }}" readonly>
                        <button class="btn btn-primary mt-2" onclick="copyReferralLink()">{{ __('Copy Link') }}</button>
                    </div>


                    <div class="referral-history mt-4">
                        <h3>{{ __('Referral History') }}</h3>
                        <table class="table table-bordered mt-4">
                            <thead>
                                <tr>
                                    <th>{{ __('Referred User') }}</th>
                                    <th>{{ __('Date Referred') }}</th>
                                    <th>{{ __('Status') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($data['referralHistory'] as $referral)
                                <tr>
                                    <td>{{ $referral->referred ? $referral->referred->name : __('Pending') }}</td>
                                    <td>{{ $referral->created_at->format('Y-m-d') }}</td>
                                    <td>{{ $referral->used_at ? __('Used') : __('Pending') }}</td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="3" class="text-center">{{ __('No referrals yet.') }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- Course -->
    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-3 row-cols-xl-3 row-cols-xxl-5 g-24 mt-0 p-0 ">



    </div>
</section>


@endsection
@section('scripts')
<script>
    function copyReferralLink() {
        var copyText = document.querySelector('.referral-link input');
        copyText.select();
        document.execCommand('copy');
        alert('{{ __("Link copied to clipboard!") }}');
    }
</script>
@endsection