@extends('panel.student.layouts.master')
@section('title', @$data['title'])
@section('content')
<!-- My Profile S t a r t -->
<section class="my-profile-area">
    <div class="row">
        <!-- Section Tittle -->
        <div class="col-xl-12">
            <div class="section-tittle-two d-flex align-items-center justify-content-between flex-wrap mb-20">
                <h2 class="title font-600">{{ @$data['title'] }}</h2>
                <span class="action-success" id="copyButton" data-url="{{ route('share.profile', ['username' => @$data['student']->user->username]) }}">
                    <i class="ri-file-copy-line"></i>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <div class="my-profile-wrapper">
                <form action="{{ route('student.update_profile') }}" method="POST" class="settings-general-info" enctype="multipart/form-data">
                    @csrf
                    <!-- Section Tittle -->
                    <div class="row">
                        <div class="col-xl-6 col-lg-12">
                            <!-- Personal Info -->
                            <div class="small-tittle-two border-bottom mb-20 pb-8">
                                <h4 class="title text-capitalize font-600">
                                    {{ ___('student.Personal Information') }}
                                </h4>
                            </div>
                            <div class="ot-contact-form mb-24">
                                <label class="ot-contact-label">{{ ___('student.Your Name') }} <span class="text-danger">*</span></label>
                                <input class="form-control ot-contact-input @error('name') is-invalid @enderror" type="text" name="name" value="{{ auth()->user()->name }}" placeholder="{{ ___('student.Name') }}">
                                @error('name')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror

                            </div>
                            <div class="ot-contact-form mb-24">
                                <label class="ot-contact-label">{{ ___('student.Phone') }} <span class="text-danger">*</span></label>
                                <input class="form-control ot-contact-input @error('phone') is-invalid @enderror" type="string" name="phone" value="{{ auth()->user()->phone ?? '' }}" placeholder="{{ ___('student.Phone') }}">
                                @error('phone')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>


                            <div class="ot-contact-form mb-24">
                                <label class="ot-contact-label">{{ ___('student.Date Of Birth') }} <span class="text-danger">*</span></label>
                                <input class="form-control ot-contact-input date-picker @error('date_of_birth') is-invalid @enderror" date-picker type="text" name="date_of_birth" value="{{ date_picker_format(@$data['student']->date_of_birth) }}" placeholder="{{ ___('student.Date Of Birth') }}">
                                @error('date_of_birth')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="ot-contact-form mb-24">
                                <label class="ot-contact-label">{{ ___('student.Gender') }} <span class="text-danger">*</span></label>
                                <select class="select_2 @error('gender') is-invalid @enderror" name="gender">
                                    <option value="{{ App\Enums\Gender::MALE }}" @if (@$data['student']->gender == App\Enums\Gender::MALE) {{ 'selected' }} @endif>
                                        {{ ___('student.Male') }}
                                    </option>
                                    <option value="{{ App\Enums\Gender::FEMALE }}" @if (@$data['student']->gender == App\Enums\Gender::FEMALE) {{ 'selected' }} @endif>
                                        {{ ___('student.Female') }}
                                    </option>
                                    <option value="{{ App\Enums\Gender::OTHERS }}" @if (@$data['student']->gender == App\Enums\Gender::OTHERS) {{ 'selected' }} @endif>
                                        {{ ___('student.Others') }}
                                    </option>
                                </select>
                                @error('gender')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>


                            <!-- Address -->
                            <div class="small-tittle-two border-bottom mb-20 pb-8 pt-24">
                                <h4 class="title text-capitalize font-600">{{ ___('student.Address') }}</h4>
                            </div>
                            <div class="ot-contact-form mb-24">
                                <label class="ot-contact-label">{{ ___('student.address') }}</label>
                                <input class="form-control ot-contact-input @error('address') is-invalid @enderror" type="text" name="address" value="{{ @$data['student']->address }}" placeholder="{{ ___('student.Enter your Address') }}">
                                @error('address')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="ot-contact-form mb-24">
                                <label class="ot-contact-label">{{ ___('student.Country') }} <span class="text-danger">*</span></label>
                                <!-- Select2 -->
                                <select class="country_list @error('country_id') is-invalid @enderror" name="country_id">
                                    <option value="">{{ ___('placeholder.Select Country') }}</option>
                                    @if (@$data['student']->country_id)
                                    <option value="{{ @$data['student']->country_id }}" selected>
                                        {{ @$data['student']->country->name }}
                                    </option>
                                    @endif
                                </select>
                                @error('country_id')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                        </div>
                        <div class="col-xl-6 col-lg-12">
                            <!-- About My Self -->
                            <div class="small-tittle-two border-bottom mb-20 pb-8">
                                <h4 class="title text-capitalize font-600">{{ ___('student.About Information') }}
                                </h4>
                            </div>

                            <div class="ot-contact-form mb-24">
                                <label class="ot-contact-label">{{ ___('student.Designation') }}</label>
                                <input class="form-control ot-contact-input @error('designation') is-invalid @enderror" type="text" name="designation" value="{{ @$data['student']->designation ?? old('designation') }}" placeholder="{{ ___('student.UI/UX Designer | Product Design | Mobile App Expert') }}">
                                @error('designation')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="ot-contact-form mb-24">
                                <label class="ot-contact-label">{{ ___('student.About') }}</label>
                                <textarea class="ot-contact-textarea @error('about_me') is-invalid @enderror" placeholder="{{ ___('student.About My Self') }}" name="about_me" id="about_me" cols="8" rows="4">{{ @$data['student']->about_me ?? old('about_me') }}</textarea>
                                @error('about_me')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <!-- uplode image -->
                            <div class="ot-contact-form mb-24">
                                <label for="profile_image" class="form-label ">{{ ___('student.Profile Image') }}
                                </label>
                                <div @if (@$data['student']->user->image) data-val="{{ showImage(@$data['student']->user->image->original) }}" @endif
                                    data-name="profile_image"
                                    class="file @error('profile_image') is-invalid @enderror"
                                    data-height="200px ">
                                </div>
                                <small class="text-muted">{{ ___('placeholder.NB : Profile size will 100px x 100px and not more than 1mb') }}</small>
                                @error('profile_image')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                        <!-- Switch Box -->
                        <div class="col-lg-12">
                            <div class="btn-wrapper mt-6">
                                <button class="btn-primary-fill">{{ ___('student.Save & Update') }}</button>
                            </div>
                        </div>
                    </div>
                </form>
               
            </div>
        </div>
    </div>
</section>
<!-- End-of Profile -->
@endsection