@extends('panel.student.layouts.master')
@section('title', @$data['title'])
@section('content')
<!-- My Profile S t a r t -->
<section class="my-profile-area">
    <div class="row">
        <!-- Section Tittle -->
        <div class="col-xl-12">
            <div class="section-tittle-two d-flex align-items-center justify-content-between flex-wrap mb-20">
                <h2 class="title font-600">{{ @$data['title'] }}</h2>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <div class="my-profile-wrapper">
                <div class="col-xl-12">
                    <div class="small-tittle-two border-bottom d-flex align-items-center justify-content-between flex-wrap gap-10 mb-20 pb-8">

                        <div class="country d-flex align-items-center ">
                            <i class="ri-phone-line"></i>
                            <span class="country text-title font-600 ml-10">{{ ___('student.Talk To Counselor') }}</span>
                        </div>

                    </div>
                </div>
                <div class="row">
                    @forelse ($data['instructors'] as $key => $instructor)
                    <!-- Single Instructor -->
                    <div class="col-xl-6 col-lg-6">

                        <div class=" single-instructor mb-24">
                            <div class="listCap">
                                <div class="instructor-img">
                                    <a href="{{ route('frontend.instructor.details', [$instructor->user->name, $instructor->user_id]) }}"><img src="{{ showImage(@$instructor->user->image->original) }}" class="img-cover" alt="images"></a>
                                </div>
                                <div class="recentCaption">
                                    <div class="d-flex align-items-center justify-content-between flex-wrap">
                                        <h5><a href="{{ route('frontend.instructor.details', [$instructor->user->name, $instructor->user_id]) }}" class="title colorEffect  font-600 mb-0">{{ @$instructor->user->name }}</a></h5>

                                    </div>
                                    <p class="rating mb-10">
                                        <i class="ri-star-fill"></i>
                                        <span class="ratting-count font-500"> ({{ @$instructor->ratings() ?? 0 }})</span>
                                        <span class="total-ratting font-600">
                                            ({{ $instructor->totalReviews() > 1 ? $instructor->totalReviews() . ' ' . ___('frontend.Ratings') : $instructor->totalReviews() . ' ' . ___('frontend.Rating') }})
                                        </span>
                                    </p>
                                    <div class="d-flex flex-wrap mb-10">
                                        <button class="btn-primary-outline " onclick="mainModalOpen(`{{ route('student.scheduleCall',$instructor->id) }}`)"><i class="ri-phone-line"></i> {{ ___('student.Schedule Call') }}</button>
                                        <button class="btn-primary-outline mt-3 " onclick="mainModalOpen(`{{ route('student.reviewCounselor',$instructor->id) }}`)"><i class="ri-feedback-line"></i> {{ ___('student.Review and Feedback') }}</button>
                                    </div>
                                    <p class="pera text-16 mb-10">{{ Str::limit( @$instructor->about_me,100) }}</p>
                                    @if (@$instructor->skills)
                                    <div class="tag-area2 d-flex align-items-center flex-wrap">
                                        <span class="tag-cout text-title text-16 font-600 mr-10 mb-16">{{ ___('frontend.Expertise') }}</span>
                                        <ul class="listing">
                                            @foreach (@$instructor->skills as $key => $skill)
                                            <li class="single-list">{{ @$skill['value'] }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- End-of Pagination -->
                    @empty
                    <div class="col-lg-12">
                        <div class="alert alert-warning">
                            {{ ___('frontend.No instructor found') }}
                        </div>
                    </div>

                    @endforelse
                    <?= $data['instructors']->links('frontend.partials.pagination', ['event' => 'coursePagination']) ?>

                    <!-- Display Scheduled Calls -->
                    <div class="col-xl-12">
                        <h3>{{ ___('student.Scheduled Calls') }}</h3>
                        @forelse ($data['scheduledCalls'] as $call)
                        <div class="scheduled-call">
                            <p>{{ ($call->instructor->user)? $call->instructor->user->name : '' }} - {{ \Carbon\Carbon::parse($call->schedule_call_date)->format('d M Y') }} at {{ \Carbon\Carbon::parse($call->call_time)->format('h:i A') }}</p>
                        </div>
                        @empty
                        <div class="alert alert-warning">
                            {{ ___('student.No scheduled calls found') }}
                        </div>
                        @endforelse
                    </div>

                </div>

            </div>
        </div>
    </div>
</section>
<!-- End-of Profile -->
@endsection