<?php $__env->startSection('title'); ?>
    <?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="page-content">

        
        <?php echo $__env->make('backend.ui-components.breadcrumb', [
            'title' => @$data['title'],
            'routes' => [
                route('dashboard') => ___('common.Dashboard'),
                '#' => @$data['title'],
            ],

            'buttons' => 1,
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        

        <!--  table content start -->
        <div class="table-content table-basic ecommerce-components product-list">
            <div class="card">
                <div class="card-body">
                    <!--  toolbar table start  -->
                    <div
                        class="table-toolbar d-flex flex-wrap gap-2 flex-column flex-xl-row justify-content-center justify-content-xxl-between align-content-center pb-3">
                        <form action="" method="get">
                            <div class="align-self-center">
                                <div
                                    class="d-flex flex-wrap gap-2 flex-column flex-lg-row justify-content-center align-content-center">
                                    <!-- show per page -->
                                    <?php echo $__env->make('backend.ui-components.per-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <!-- show per page end -->

                                    <!-- start categories -->
                                    <div class="align-self-center">
                                        <div class="dropdown dropdown-designation" data-bs-toggle="tooltip"
                                            data-bs-placement="top" data-bs-title="<?php echo e(___('common.Category')); ?>">
                                            <select id="single" class="select2 form-control cus-dropdown-seelct"
                                                name="category_id">
                                                <option value="0" selected disabled>
                                                    <?php echo e(___('common.Select Category')); ?></option>
                                                <?php if($data['categoriesArr']): ?>
                                                    <?php $__currentLoopData = $data['categoriesArr']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $catId => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php if(@request()->category_id == $catId): ?> <?php echo e('selected'); ?> <?php endif; ?>
                                                            value="<?php echo e($catId); ?>"><?php echo e($category); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <!-- end categories -->


                                    <div class="align-self-center d-flex gap-2">
                                        <!-- search start -->
                                        <div class="align-self-center">
                                            <div class="search-box d-flex">
                                                <input class="form-control" placeholder="<?php echo e(___('common.search')); ?>"
                                                    name="search" value="<?php echo e(@request()->search); ?>" />
                                                <span class="icon"><i class="fa-solid fa-magnifying-glass"></i></span>
                                            </div>
                                        </div>
                                        <!-- search end -->


                                        <!-- dropdown action -->
                                        <div class="align-self-center">
                                            <div class="dropdown dropdown-action">
                                                <button type="submit" class="btn-add">
                                                    <span class="icon"><?php echo e(___('common.Filter')); ?></span>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>


                        <!-- add btn start -->
                        <?php if(hasPermission('blog_create')): ?>
                            <div class="align-self-center d-flex gap-2">
                                <!-- add btn -->
                                <div class="align-self-center">
                                    <a href="<?php echo e(route('blog.create')); ?>" role="button" class="btn-add"
                                        data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Add">
                                        <span><i class="fa-solid fa-plus"></i> </span>
                                        <span class="d-none d-xl-inline"><?php echo e(___('common.add')); ?></span>
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                        <!-- add btn end -->
                    </div>
                    <!--toolbar table end -->
                    <!--  table start -->
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="thead">
                                <!-- start table header from ui-helper function -->
                                <?php echo e(table_header('', $data['tableHeader'])); ?>

                                <!-- end table header from ui-helper function -->
                            </thead>
                            <tbody class="tbody">

                                <?php $__empty_1 = true; $__currentLoopData = $data['blogs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(@$blog->id); ?></td>
                                        <td><?php echo e(Str::limit(@$blog->title, 20)); ?></td>
                                        <td>
                                            <img src="<?php echo e(showImage(@$blog->iconImage->paths['35x35'], 'default-1.jpeg')); ?>"
                                                alt="<?php echo e(@$blog->title); ?>" width="35px">
                                        </td>
                                        <td><?php echo e(@$blog->category->title); ?></td>
                                        <td>
                                            <?php echo e(statusBackend(@$blog->status->class, @$blog->status->name)); ?>

                                        </td>

                                        <td class="create-date"><?php echo e(showDate(@$blog->created_at)); ?></td>

                                        <td class="action">
                                            <div class="dropdown dropdown-action">
                                                <button type="button" class="btn-dropdown" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-end">

                                                    <li>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('blog_details', $blog->id)); ?>"><span
                                                                class="icon mr-12"><i class="fa-solid fa-eye"></i></span>
                                                            <?php echo e(___('common.View')); ?></a>
                                                    </li>
                                                    <?php if(hasPermission('blog_update')): ?>
                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('blog.edit', $blog->id)); ?>"><span
                                                                    class="icon mr-12"><i
                                                                        class="fa-solid fa-pen-to-square"></i></span>
                                                                <?php echo e(___('common.edit')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('blog_delete')): ?>
                                                        <li>
                                                            <a class="dropdown-item delete_data" href="javascript:void(0);"
                                                                data-href="<?php echo e(route('blog.destroy', $blog->id)); ?>">
                                                                <span class="icon mr-8"><i
                                                                        class="fa-solid fa-trash-can"></i></span>
                                                                <span><?php echo e(___('common.delete')); ?></span>
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <!-- empty table -->
                                    <?php echo $__env->make('backend.ui-components.empty_table', [
                                        'colspan' => '7',
                                        'message' => ___(
                                            'message.Please add a new entity or manage the data table to see the content here'),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <!-- empty table -->
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <!--  table end -->
                    <!--  pagination start -->
                    <?php echo $__env->make('backend.ui-components.pagination', ['data' => $data['blogs']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!--  pagination end -->
                </div>
            </div>
        </div>
        <!--  table content end -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('backend.partials.delete-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/Modules/Career/Resources/views/blog/index.blade.php ENDPATH**/ ?>