<?php $__env->startSection('title'); ?>
    <?php echo e(___('common.Dashboard')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    
    <link rel="stylesheet" href="<?php echo e(asset('backend')); ?>/assets/css/apexcharts.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <div class="row g-4">

            <!-- Welcome Title -->
            <div class="col-12">
                <div class="row">
                    <div class="dashboard-heading row align-items-center mt-6">
                        <div class="col-12 col-md-6 col-xl-6 col-lg-6">
                            <h3 class="title"><?php echo e(___('dashboard.hello')); ?>, <?php echo e(Auth::user()->name); ?></h3>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dashboard Summery Card Start -->
            <div class="col-12 summery-card">
                <div class="row g-4">
                    <div class="col-12 col-md-6 col-lg-3 col-xl-3">
                        <div class="card summery-card ot-card h-100">
                            <div class="card-heading d-flex align-items-center">
                                <div class="card-icon circle-success dashboard-card-icon">
                                    <i class="las la-users"></i>
                                </div>
                                <div class="card-content">
                                    <h4><?php echo e(___('dashboard.Total_Student')); ?></h4>
                                    <h1><?php echo e(shorten_number(@$data['student'] ?? 0)); ?></h1>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3 col-xl-3">
                        <div class="card summery-card ot-card h-100">
                            <div class="card-heading d-flex align-items-center">
                                <div class="card-icon circle-warning dashboard-card-icon">
                                    <i class="las la-users"></i>
                                </div>
                                <div class="card-content">
                                    <h4><?php echo e(___('dashboard.Total_Instructor')); ?></h4>
                                    <h1><?php echo e(shorten_number($data['instructor'] ?? 0)); ?></h1>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3 col-xl-3">
                        <div class="card summery-card ot-card h-100">
                            <div class="card-heading d-flex align-items-center">
                                <div class="card-icon  circle-lightseagreen dashboard-card-icon">
                                    <i class="las la-book-open"></i>
                                </div>
                                <div class="card-content">
                                    <h4><?php echo e(___('dashboard.Total_Course')); ?></h4>
                                    <h1><?php echo e(shorten_number(@$data['course'] ?? 0)); ?></h1>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-3 col-xl-3">
                        <div class="card summery-card ot-card h-100">
                            <div class="card-heading d-flex align-items-center">
                                <div class="card-icon circle-danger dashboard-card-icon">
                                    <i class="las la-chart-area"></i>
                                </div>
                                <div class="card-content">
                                    <h4><?php echo e(___('dashboard.Total_Sales')); ?></h4>
                                    <h1><?php echo e(shorten_number(@$data['enroll'] ?? 0)); ?></h1>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Dashboard Summery Card End -->

            <div class="col-12 statistic-card">
                <div class="row g-4">
                    <div class="ot-charts col-12 col-xxl-12">
                        <div class="card statistic-card ot-card">
                            <div class="card-header">
                                <div class="card-title">
                                    <h4><?php echo e(___('dashboard.Revenue')); ?></h4>
                                </div>
                            </div>
                            
                            <div id="revenueChart"></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-12 col-xl-12 ">
                <div class="ot-card chart-card2 h-calc">

                    
                    <div class="card-header d-flex justify-content-between">
                        <div class="card-title">
                            <h4><?php echo e(___('dashboard.Sales')); ?></h4>
                        </div>
                    </div>

                    
                    <div id="sales_chart" class=""></div>
                </div>
            </div>

            <div class="col-12">
                <div class="row g-4">
                    <div class="ot-charts col-xxl-8 col-xl-8 table-content table-basic">
                        <div class="card ot-card ot-visit-chart h-calc">
                            <div class="card-title mb-20">
                                <h4><?php echo e(___('dashboard.Top_courses')); ?></h4>
                            </div>

                            <div class="table-responsive ">
                                <table class="table table-bordered">
                                    <thead class="thead">
                                        <tr>
                                            <th><?php echo e(___('common.ID')); ?></th>
                                            <th><?php echo e(___('common.name')); ?> </th>
                                            <th><?php echo e(___('student.Enroll')); ?></th>
                                            <th><?php echo e(___('common.Sales')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody class="tbody">
                                        <?php $__empty_1 = true; $__currentLoopData = $data['top_courses']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>
                                                    <?php echo e(@$key + 1); ?>

                                                </td>
                                                <td>
                                                    <a href="<?php echo e(route('frontend.courseDetails', @$course->slug)); ?>"
                                                        class="text-peragraph">
                                                        <?php echo e(Str::limit(@$course->title, 40)); ?>

                                                    </a>
                                                </td>
                                                <td>
                                                    <?php echo e(@$course->totalEnroll()); ?>

                                                </td>
                                                <td>
                                                    <?php echo e(showPrice(@$course->totalAmountSales())); ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <!-- empty table -->
                                            <?php echo $__env->make('backend.ui-components.empty_table', [
                                                'colspan' => '4',
                                                'message' => ___(
                                                    'message.Please add a new entity or manage the data table to see the content here'),
                                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <!-- empty table -->
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                            <!--  table end -->
                        </div>
                    </div>
                    <div class="ot-charts col-12 col-xxl-4">
                        <div class="card ot-card ot-visit-chart h-calc">
                            <div class="card-header">
                                <div class="card-title">
                                    <h4><?php echo e(___('dashboard.Summary')); ?></h4>
                                </div>
                            </div>
                            <div class="card-body">
                                <ul class="list-group list-group-flush height-300 nice-scroll">

                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-users fs-5"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"> <?php echo e(___('dashboard.Total_Student')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(shorten_number(@$data['student'] ?? 0)); ?>

                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-user fs-5"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"><?php echo e(___('dashboard.Total_Instructor')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(shorten_number(@$data['instructor'] ?? 0)); ?>

                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-book-open fs-5"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"><?php echo e(___('dashboard.Total_Active_Course')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(shorten_number(@$data['active_course'] ?? 0)); ?>

                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-book-open fs-5"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"><?php echo e(___('dashboard.Total_Pending_Course')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(shorten_number(@$data['pending_course'] ?? 0)); ?>

                                        </span>
                                    </li>

                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-book-open fs-5"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"><?php echo e(___('dashboard.Featured_Course')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(shorten_number(@$data['featured_course'] ?? 0)); ?>

                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-book-open fs-5"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"><?php echo e(___('dashboard.Discount_Course')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(shorten_number(@$data['discount_course'] ?? 0)); ?>

                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-circle"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"><?php echo e(___('dashboard.Total_Sales')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(shorten_number(@$data['enroll'] ?? 0)); ?>

                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-circle"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"><?php echo e(___('dashboard.Certificates')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(shorten_number(@$data['certificate_generate'] ?? 0)); ?>

                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-circle"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"><?php echo e(___('dashboard.Pending_Payout')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(shorten_number(@$data['pending_payout'] ?? 0)); ?>

                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-dollar-sign"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"><?php echo e(___('dashboard.Income')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(showPrice(@$data['income'] ?? 0)); ?>

                                        </span>
                                    </li>
                                    <li class="list-group-item d-flex gap-2 justify-content-between align-items-center">
                                        <div class="badge badge-light-primary">
                                            <i class="las la-dollar-sign"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="title"><?php echo e(___('dashboard.Expense')); ?></div>
                                        </div>
                                        <span class="badge badge-light-success fs-8 fw-bold">
                                            <?php echo e(showPrice(@$data['expense'] ?? 0)); ?>

                                        </span>
                                    </li>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            


            <!--  top five student start -->
            <div class="col-lg-6 table-content table-basic">
                <div class="card h-calc">
                    <div class="card-body">
                        <div class="card-title mb-20">
                            <h4><?php echo e(___('dashboard.Top_Five_Students')); ?></h4>
                        </div>

                        <div class="table-responsive table-height-350 niceScroll">
                            <table class="table table-bordered">
                                <thead class="thead">
                                    <tr>
                                        <th class="serial"><?php echo e(___('common.ID.')); ?></th>
                                        <th class="purchase"><?php echo e(___('common.name')); ?></th>
                                        <th class="purchase"><?php echo e(___('student.Enroll')); ?></th>
                                        <th class="purchase"><?php echo e(___('student.Point')); ?></th>
                                        <th class="purchase"><?php echo e(___('common.status')); ?></th>
                                    </tr>
                                </thead>
                                <tbody class="tbody">
                                    <?php $__empty_1 = true; $__currentLoopData = $data['top_students']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e(++$key); ?></td>
                                            <td>
                                                <?php echo e(@$student->user->name); ?>

                                            </td>
                                            <td><?php echo e(@$student->points); ?></td>
                                            <td><?php echo e(@$student->enrollments->count()); ?></td>
                                            <td>
                                                <?php if(@$student->user->status == App\Enums\Status::ACTIVE): ?>
                                                    <span
                                                        class="badge-basic-success-text"><?php echo e(___('common.Active')); ?></span>
                                                <?php else: ?>
                                                    <span
                                                        class="badge-basic-danger-text"><?php echo e(___('common.Inactive')); ?></span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <!-- empty table -->
                                        <?php echo $__env->make('backend.ui-components.empty_table', [
                                            'colspan' => '5',
                                            'message' => ___(
                                                'message.Please add a new entity or manage the data table to see the content here'),
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <!-- empty table -->
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <!--  table end -->
                    </div>
                </div>
            </div>
            <!--  top five student end -->

            <!--  top five instructor start -->
            <div class="col-lg-6 table-content table-basic">
                <div class="card h-calc">
                    <div class="card-body">
                        <div class="card-title mb-20">
                            <h4><?php echo e(___('dashboard.Top_Five_Instructors')); ?></h4>
                        </div>

                        <div class="table-responsive table-height-350 niceScroll">
                            <table class="table table-bordered">
                                <thead class="thead">
                                    <tr>
                                        <th class="serial"><?php echo e(___('common.ID.')); ?></th>
                                        <th class="purchase"><?php echo e(___('common.name')); ?></th>
                                        <th class="purchase"><?php echo e(___('course.Courses')); ?></th>
                                        <th class="purchase"><?php echo e(___('common.Sales')); ?></th>
                                        <th class="purchase"><?php echo e(___('common.status')); ?></th>
                                    </tr>
                                </thead>
                                <tbody class="tbody">
                                    <?php $__empty_1 = true; $__currentLoopData = $data['top_instructors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e(++$key); ?></td>
                                            <td>
                                                <?php echo e(@$instructor->user->name); ?>

                                            </td>
                                            <td><?php echo e(@$instructor->courses->count()); ?></td>
                                            <td><?php echo e(@$instructor->user->courseEnroll ? @$instructor->user->courseEnroll->count() : 0); ?></td>
                                            <td>
                                                <?php if(@$instructor->user->status == App\Enums\Status::ACTIVE): ?>
                                                    <span
                                                        class="badge-basic-success-text"><?php echo e(___('common.Active')); ?></span>
                                                <?php else: ?>
                                                    <span
                                                        class="badge-basic-danger-text"><?php echo e(___('common.Inactive')); ?></span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <!-- empty table -->
                                        <?php echo $__env->make('backend.ui-components.empty_table', [
                                            'colspan' => '5',
                                            'message' => ___(
                                                'message.Please add a new entity or manage the data table to see the content here'),
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <!-- empty table -->
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <!--  table end -->
                    </div>
                </div>
            </div>
            <!--  top five instructor end -->


        </div>
        <!-- table leave container end -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('backend')); ?>/vendors/apexchart/js/apexcharts.min.js"></script>
    <script src="<?php echo e(asset('backend')); ?>/assets/js/apex-chart.js"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/resources/views/backend/dashboard.blade.php ENDPATH**/ ?>