<body class="panel light-mode <?php echo e(@findDirectionOfLang()); ?>" dir="<?php echo e(@findDirectionOfLang()); ?>">
    <header>
        <div class="header-area panel-b m-0 p-0">
            <div class="main-header">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="menu-wrapper d-flex align-items-center justify-content-between">
                                <div class="d-flex align-items-center">
                                    <!-- Mobile Device sidebar open Icon -->
                                    <div class="panel-sidebar-icon">
                                        <div class="sidebar-icon"><i class="ri-arrow-left-right-line"></i> </div>
                                    </div>
                                    <!-- Home panel -->
                                    <div class="home-panel">
                                        <a href="<?php echo e(url('/')); ?>" class="panel-home">
                                            <i class="ri-home-4-line"></i>
                                        </a>
                                    </div>
                                </div>

                                <!-- Cart -->
                                <ul class="cart">
                                    <!-- Mode Change -->
                                    <!-- <li class="cart-list">
                                        <button class="single change-mode m-0 p-2 border-0">
                                            <i class="ri-sun-line"></i>
                                        </button>
                                    </li> -->

                                    <!-- Language -->
                                    <li class="cart-list">
                                        <select class="language-select select_2" id="language-select">
                                            <?php $__currentLoopData = language(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($language->code); ?>"
                                                    <?php echo e($language->code == session()->get('locale') ? 'selected' : ''); ?>>
                                                    <?php echo e($language->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </select>
                                    </li>

                                    <!-- Cart -->
                                    <li class="cart-list shopping-cart position-relative">
                                        <a href="<?php echo e(route('cart.index')); ?>" class="cart-items">
                                            <i class="ri-shopping-cart-line"></i>
                                            <span class="count"><?php echo e(count(Session()->get('cart') ?? [])); ?></span>
                                        </a>
                                    </li>

                                    <!-- After Login -->
                                    <?php echo $__env->make('panel.student.include.profile_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </ul>
                            </div>
                            <!-- Mobile Menu -->
                            <div class="div">
                                <div class="mobile_menu d-block d-lg-none"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Mobile Munu Footer -->
        <div class="mobile-menu-footer">
            <div class="container-fluid-fluid p-0">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="footer-mobile-wrapper">
                            <ul class="listing">
                                <li class="single-list">
                                    <a href="<?php echo e(route('student.dashboard')); ?>" class="active">
                                        <i class="ri-dashboard-line"></i>
                                        <span><?php echo e(___('frontend.Dashboard')); ?> </span>
                                    </a>
                                </li>
                                <li class="single-list">
                                    <a href="<?php echo e(route('student.profile')); ?>">
                                        <i class="ri-user-line"></i>
                                        <span><?php echo e(___('frontend.Profile')); ?></span>
                                    </a>
                                </li>
                                <li class="single-list">
                                    <a href="<?php echo e(url('/')); ?>" class="home-btn">
                                        <i class="ri-home-4-line"></i>
                                    </a>
                                </li>
                                <li class="single-list counter">
                                    <a href="<?php echo e(route('cart.index')); ?>">
                                        <i class="ri-shopping-cart-line"></i>
                                        <span><?php echo e(___('frontend.Cart')); ?></span>
                                        <span class="count"><?php echo e(count(Session()->get('cart') ?? [])); ?></span>
                                    </a>
                                </li>
                                <li class="single-list counter">
                                    <a href="<?php echo e(route('student.course')); ?>">
                                        <i class="ri-book-open-line"></i>
                                        <span><?php echo e(___('frontend.Courses')); ?></span>
                                    </a>
                                </li>

                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /End-of footer Menu -->
    </header>
<?php /**PATH /home/nexprism/eduroutez.nexprism.com/resources/views/panel/student/include/header.blade.php ENDPATH**/ ?>