<?php $__env->startSection('title', @$data['title']); ?>
<?php $__env->startSection('content'); ?>
<!-- Dashboard Card Start -->
<style>
    .pricing {
        display: flex;
        justify-content: center;
        align-items: center;


        isolation: isolate;
    }

    @media (max-width: 540px) {
        .pricing {
            flex-direction: column;
        }
    }

    .card {
        flex: 1;
        max-width: 300px;
        padding: 16px 32px;
        border-radius: 8px;
        background: white;
        box-shadow: 0px 2px 16px hsl(260deg 50% 20% / 0.7);


        position: relative;
        z-index: 1;
    }

    .primary.card {
        flex: 1.25;
        max-width: 350px;


        z-index: 2;
        margin: -32px -16px;
    }

    .card h2 {
        font-size: 1rem;
        font-weight: 500;
        color: hsl(0deg 0% 40%);
    }

    .price {
        font-size: 2rem;
        font-weight: 700;
    }

    .card button {
        width: 100%;
        height: 3rem;
    }
</style>
<!-- End-of card -->
<!-- instructor Courses activity Start -->
<section class="instructor-courses-activity">
    <div class="row">
        <!-- Section Title -->
        <div class="col-xl-12">
            <div class="section-title-two d-flex align-items-center justify-content-between flex-wrap">
                <h2 class="title font-600 mb-20"><?php echo e($data['title']); ?></h2>
                <div class="right d-flex flex-wrap justify-content-between">
                </div>
            </div>
        </div>
    </div>

</section>

<section class="pricing">
    <?php $__currentLoopData = $data['subscriptions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <article class="card <?php echo e((auth()->user()->subscription_id == $subscription->id) ? 'primary':''); ?>">
        <h2><?php echo e($subscription->name); ?></h2>
        <div class="price">₹ <?php echo e($subscription->price); ?> / <span style="font-size:12px"> <?php echo e($subscription->duration_type); ?></span> </div>

        <ul>
            <?php $__currentLoopData = $subscription->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($feature->value); ?> <?php echo e($feature->name); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </ul>

        <?php if(auth()->user()->subscription_id == $subscription->id): ?>
        <div class="p-3">
            <form action="<?php echo e(route('subscription.organization.upgrade', $subscription->id)); ?>" method="post">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-primary">Upgrade</button>
            </form>
        </div>
        <?php else: ?>
        <div class="p-3">

            <form action="<?php echo e(route('organization.subscription.subscribe', $subscription->id)); ?>" method="post">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-primary">Subscribe</button>
            </form>
        </div>
        <?php endif; ?>
    </article>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



</section>
<!-- End-of courses activity  -->
<!--  pagination start -->

<!--  pagination end -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('organization::panel.organization.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/Modules/Organization/Resources/views/panel/organization/subscription/subscription_list.blade.php ENDPATH**/ ?>