<?php $__env->startSection('title', @$data['title']); ?>
<?php $__env->startSection('content'); ?>
<!-- Courses -->
<section>
    <div class="row">
        <!-- Section Tittle -->
        <div class="col-xl-12">
            <div class="section-tittle-two border-bottom d-flex align-items-center justify-content-between flex-wrap mb-10 pb-20 gap-15">
                <h2 class="title font-600"><?php echo e($data['title']); ?></h2>
                <div class="right d-flex flex-wrap justify-content-between">
                    <!-- Search Box -->

                    <!-- /End -->
                </div>
            </div>
        </div>

        <!-- Search -->
    </div>

    <div class="row">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h3><?php echo e(__('common.Refer and Earn')); ?></h3>
                    <p><?php echo e(__('common.Share your referral link and earn rewards!')); ?></p>
                    <div class="referral-link">
                        <input type="text" class="form-control" value="<?php echo e($data['referralLink']); ?>" readonly>
                        <button class="btn btn-primary mt-2" onclick="copyReferralLink()"><?php echo e(__('Copy Link')); ?></button>
                    </div>


                    <div class="referral-history mt-4">
                        <h3><?php echo e(__('Referral History')); ?></h3>
                        <table class="table table-bordered mt-4">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Referred User')); ?></th>
                                    <th><?php echo e(__('Date Referred')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data['referralHistory']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($referral->referred ? $referral->referred->name : __('Pending')); ?></td>
                                    <td><?php echo e($referral->created_at->format('Y-m-d')); ?></td>
                                    <td><?php echo e($referral->used_at ? __('Used') : __('Pending')); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center"><?php echo e(__('No referrals yet.')); ?></td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!-- Course -->
    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-3 row-cols-xl-3 row-cols-xxl-5 g-24 mt-0 p-0 ">



    </div>
</section>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    function copyReferralLink() {
        var copyText = document.querySelector('.referral-link input');
        copyText.select();
        document.execCommand('copy');
        alert('<?php echo e(__("Link copied to clipboard!")); ?>');
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('panel.student.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/resources/views/panel/student/refer_earn.blade.php ENDPATH**/ ?>