<!DOCTYPE html>
<html lang="en" dir="<?php echo e(@findDirectionOfLang()); ?>">

<head>
    <meta charset="utf-8">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(setting('application_name')); ?></title>
    <!-- <link rel="icon" type="image/x-icon" href="<?php echo e(@showImage(setting('favicon'), 'favicon.png')); ?>"> -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('updated_frontend/images/favicon.png')); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <input type="hidden" name="url" id="url" value="<?php echo e(url('')); ?>">

    <meta name="keywords" content="<?php echo e(setting('meta_keyword')); ?>">
    <meta name="author" content="<?php echo e(setting('author')); ?>">
    <meta name="description" content="<?php echo e(setting('meta_description')); ?>">

    <?php if(findDirectionOfLang() == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('backend')); ?>/assets/css/bootstrap.rtl.min.css">
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(asset('backend')); ?>/assets/css/bootstrap.min.css">
    <?php endif; ?>

    <!-- css  -->
    <!-- metis menu for sidebar  -->
    <link rel="stylesheet" href="<?php echo e(asset('backend')); ?>/assets/css/metisMenu.min.css">
    
    <link rel="stylesheet" href="<?php echo e(asset('backend')); ?>/assets/css/icon-fonts.css">
    <!-- All Plugin  -->
    <link rel="stylesheet" href="<?php echo e(asset('backend')); ?>/assets/css/plugin.css">
    <!-- Custom CSS  start -->
    <link rel="stylesheet" href="<?php echo e(asset('backend')); ?>/assets/css/style.css">
    <?php echo $__env->yieldPushContent('css'); ?>
</head>

<body class="<?php echo e(@findDirectionOfLang()); ?> default-theme" dir="<?php echo e(@findDirectionOfLang()); ?>">

    <div id="layout-wrapper">
        <!-- start header -->
        <?php echo $__env->make('backend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- end header -->

        <!-- start sidebar -->
        <?php echo $__env->make('backend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- end sidebar -->
        
        <main class="main-content ph-32 pt-100">
            <!-- start main content -->
            <?php echo $__env->yieldContent('content'); ?>
            <!-- end main content -->

            <!-- start footer -->
            <?php echo $__env->make('backend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- end footer -->
        </main>
    </div>
    <!-- start lang static -->
    <?php echo $__env->make('backend.partials.lang-static', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- end lang static -->
    
    <script src="<?php echo e(asset('backend')); ?>/assets/js/theme.js"></script>
    
    <script src="<?php echo e(asset('backend')); ?>/assets/js/popper.min.js"></script>
    <script src="<?php echo e(asset('backend')); ?>/assets/js/bootstrap.min.js"></script>
    <script src="<?php echo e(asset('backend')); ?>/assets/js/jquery-3.7.0.min.js"></script>
    <!-- Metis menu for sidebar  -->
    <script src="<?php echo e(asset('backend')); ?>/assets/js/metisMenu.min.js"></script>
    <!-- Metis menu for sidebar  -->
    
    <script src="<?php echo e(asset('backend')); ?>/assets/js/plugin.js"></script>
    
    <script src="<?php echo e(asset('backend')); ?>/assets/js/ckeditor.js"></script>
    
    <?php echo $__env->make('backend.partials.alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <script src="<?php echo e(asset('backend')); ?>/assets/js/main.js"></script>
    
    <script src="<?php echo e(asset('backend')); ?>/assets/js/multi_image.js"></script>
    <script src="<?php echo e(asset('backend')); ?>/assets/js/file-uploader.js"></script>
    <?php echo $__env->yieldPushContent('script'); ?>
    <script src="<?php echo e(asset('backend')); ?>/assets/js/custom.js"></script>
    <script src="<?php echo e(asset('backend')); ?>/assets/js/select-request.js"></script>  

</body>

</html>
<?php /**PATH /home/nexprism/eduroutez.nexprism.com/resources/views/backend/master.blade.php ENDPATH**/ ?>