<?php $__env->startSection('title'); ?>
    <?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-content">
        
        <?php echo $__env->make('backend.ui-components.breadcrumb', [
            'title' => @$data['title'],
            'routes' => [
                route('dashboard') => ___('common.Dashboard'),
                '#' => @$data['title'],
            ],

            'buttons' => 1,
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        

        <!--  table content start -->
        <div class="table-content table-basic ecommerce-components product-list">
            <div class="card">
                <div class="card-body">
                    <!--  toolbar table start  -->
                    <div
                        class="table-toolbar d-flex flex-wrap gap-2 flex-column flex-xl-row justify-content-center justify-content-xxl-between align-content-center pb-3">
                        <form action="" method="get">
                            <div class="align-self-center">
                                <div
                                    class="d-flex flex-wrap gap-2 flex-column flex-lg-row justify-content-center align-content-center">
                                    <!-- show per page -->
                                    <?php echo $__env->make('backend.ui-components.per-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <!-- show per page end -->

                                    <div class="align-self-center d-flex gap-2">
                                        <!-- search start -->
                                        <div class="align-self-center">
                                            <div class="search-box d-flex">
                                                <input class="form-control" placeholder="<?php echo e(___('common.search')); ?>"
                                                    name="search" value="<?php echo e(@$_GET['search']); ?>" />
                                                <span class="icon"><i class="fa-solid fa-magnifying-glass"></i></span>
                                            </div>
                                        </div>
                                        <!-- search end -->

                                        <!-- dropdown action -->
                                        <div class="align-self-center">
                                            <div class="dropdown dropdown-action" data-bs-toggle="tooltip"
                                                data-bs-placement="top" data-bs-title="Filter">
                                                <button type="submit" class="btn-add">
                                                    <span class="icon"><?php echo e(___('common.Filter')); ?></span>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!--toolbar table end -->
                    <!--  table start -->
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="thead">
                                <tr>
                                    <th><?php echo e(___('common.ID')); ?></th>
                                    <th><?php echo e(___('common.Name')); ?></th>
                                    <th><?php echo e(___('common.Course')); ?></th>
                                    <th><?php echo e(___('common.Sales')); ?></th>
                                    <th><?php echo e(___('organization.Income')); ?></th>
                                    <th><?php echo e(___('organization.Balance')); ?></th>
                                    <th><?php echo e(___('common.Status')); ?></th>
                                    <th><?php echo e(___('common.Created_at')); ?></th>
                                    <th><?php echo e(___('common.Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody class="tbody">

                                <?php $__empty_1 = true; $__currentLoopData = $data['organizations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $organization): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(@$organization->id); ?></td>
                                        <td>

                                            <div class="d-flex align-items-center">
                                                <div class="product-image">
                                                    <img src="<?php echo e(showImage(@$organization->user->image->original, 'default-1.jpeg')); ?>"
                                                        alt="<?php echo e(@$organization->user->name); ?>">
                                                </div>
                                                <div class="product-name ml-10">
                                                    <?php echo e(Str::limit(@$organization->user->name, 20)); ?>

                                                </div>
                                            </div>
                                        </td>
                                        <td> <?php echo e(@$organization->courses->count()); ?> </td>
                                        <td> <?php echo e(@$organization->enroll->count()); ?> </td>
                                        <td><?php echo e(showPrice(@$organization->earnings)); ?></td>
                                        <td><?php echo e(showPrice(@$organization->balance)); ?></td>
                                        <td>
                                            <?php echo e(statusBackend(@$organization->user->userStatus->class, $organization->user->userStatus->name)); ?>

                                        </td>

                                        <td class="create-date"><?php echo e(showDate(@$organization->created_at)); ?></td>

                                        <td class="action">
                                            <div class="dropdown dropdown-action">
                                                <button type="button" class="btn-dropdown" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-end">

                                                    <?php if(hasPermission('organization_login')): ?>
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('admin.organization.login', $organization->id)); ?>">
                                                                <span
                                                                    class="icon mr-12">
                                                                    <i class="fa-solid fa-user-shield"></i>
                                                                </span>
                                                                <?php echo e(___('common.Login')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('organization_approve')): ?>
                                                    <li>
                                                        <a class="dropdown-item status_update" href="javascript:void(0);"
                                                            data-text="<?php echo e(___('common.Approve')); ?>" data-href="<?php echo e(route('organization.admin.approve', $organization->id)); ?>">
                                                            <span class="icon mr-12">
                                                                <i class="fa-solid fa-user-check"></i>
                                                            </span>
                                                            <?php echo e(___('common.Approve')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('organization_suspend')): ?>
                                                        <li>
                                                            <a class="dropdown-item status_update" href="javascript:void(0);"
                                                                data-text="<?php echo e(___('common.Suspend')); ?>" data-href="<?php echo e(route('organization.admin.suspend', $organization->id)); ?>">
                                                                <span class="icon mr-12">
                                                                    <i class="fa-solid fa-user-lock"></i>
                                                                </span>
                                                                <?php echo e(___('common.Suspend')); ?></a>
                                                        </li>
                                                    <?php endif; ?>

                                                    <?php if(hasPermission('organization_update')): ?>
                                                        <li>
                                                            <a class="dropdown-item" href="<?php echo e(route('organization.admin.edit', [$organization->id, 'general'])); ?>">
                                                                <span class="icon mr-12">
                                                                    <i class="fa-solid fa-pen-to-square"></i>
                                                                </span>
                                                                <?php echo e(___('common.edit')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('organization_suspend')): ?>
                                                        <li>
                                                            <a class="dropdown-item delete_data" href="javascript:void(0);" data-href="<?php echo e(route('organization.admin.destroy', $organization->id)); ?>">
                                                                <span class="icon mr-8">
                                                                    <i class="fa-solid fa-trash-can"></i>
                                                                </span>
                                                                <span><?php echo e(___('common.delete')); ?></span>
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <!-- empty table -->
                                    <?php echo $__env->make('backend.ui-components.empty_table', [
                                        'colspan' => '9',
                                        'message' => ___(
                                            'message.Please add a new entity or manage the data table to see the content here'),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <!-- empty table -->
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <!--  table end -->
                    <!--  pagination start -->
                    <?php echo $__env->make('backend.ui-components.pagination', ['data' => $data['organizations']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!--  pagination end -->
                </div>
            </div>
        </div>
        <!--  table content end -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/Modules/Organization/Resources/views/panel/organization/request.blade.php ENDPATH**/ ?>