<?php $__env->startSection('title', @$data['title']); ?>
<?php $__env->startSection('content'); ?>
    <!-- Courses -->
    <section>
        <div class="row">
            <!-- Section Tittle -->
            <div class="col-xl-12">
                <div
                    class="section-tittle-two border-bottom d-flex align-items-center justify-content-between flex-wrap mb-10 pb-20 gap-15">
                    <h2 class="title font-600"><?php echo e($data['title']); ?></h2>
                    <div class="right d-flex flex-wrap justify-content-between gap-15">
                        <!-- Search Box -->
                        <form action="" class="search-box-style">
                            <div class="responsive-search-box">
                                <input class="ot-search " type="text" name="search"
                                    placeholder="<?php echo e(___('placeholder.Search Courses')); ?>" value="<?php echo e(@$_GET['search']); ?>">
                                <!-- icon -->
                                <div class="search-icon">
                                    <i class="ri-search-line"></i>
                                </div>
                                <!-- Button -->
                                <button class="search-btn">
                                    <?php echo e(___('frontend.Search')); ?>

                                </button>
                            </div>
                        </form>
                        <!-- /End -->
                        <div class="search-tab ">
                            <a class="btn-primary-fill" href="<?php echo e(route('organization.add_course')); ?>">
                                <?php echo e(___('organization.Add New Course')); ?> <i class="ri-upload-2-line"></i>
                            </a>
                        </div>
                    </div>


                </div>
            </div>

            <!-- Search -->
        </div>

        <!-- Course -->
        <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-3 row-cols-xl-3 row-cols-xxl-5 g-24 mt-0 p-0 ">
            <?php $__empty_1 = true; $__currentLoopData = $data['courses']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col">
                    <div class="my-single-courses white-bg position-relative radius-8 h-calc">
                        <a class="course-badge position-absolute text-10 font-400 radius-4 "
                            href="<?php echo e(route('frontend.courseDetails', $course->slug)); ?>"><?php echo e(@$course->category->title); ?></a>
                        <div class="video-img2 overly1">
                            <a href="<?php echo e(route('frontend.courseDetails', $course->slug)); ?>">
                                <img src="<?php echo e(showImage(@$course->thumbnailImage->original)); ?>" class="img-cover"
                                    alt="img"> </a>
                            <!--Edit DropDown -->
                            <div class="course-edit">
                                <div class="activity-dropdown">
                                    <button class="dropdown-toggle"></button>
                                    <ul class="dropdown">

                                        <li>
                                            <a href="<?php echo e(route('frontend.courseDetails', $course->slug)); ?>"
                                                class="action-tertiary">
                                                <i class="ri-eye-line"></i>
                                            </a>
                                        </li>
                                        <?php if(module('LiveClass')): ?>
                                            <li>
                                                <a href="<?php echo e(route('organization.frontend_live_class.index', $course->slug)); ?>"
                                                    class="action-primary">
                                                    <i class="ri-live-line"></i>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <li>
                                            <a href="<?php echo e(route('organization.course.edit', $course->slug)); ?>"
                                                class="action-success">
                                                <i class="ri-pencil-line"></i>
                                            </a>
                                        </li>
                                        <li class="mb-2">
                                            <a href="javascript:;" class="action-danger"
                                                onclick="deleteFunction(`<?php echo e(route('organization.course.delete', $course->id)); ?>`)">
                                                <i class="ri-delete-bin-line"></i>
                                            </a>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                            <!--video icon -->
                        </div>
                        <div class="course-caption">
                            <h4>
                                <a href="<?php echo e(route('frontend.courseDetails', $course->slug)); ?>"
                                    class="title colorEffect font-600 d-block line-clamp-2  mb-10"><?php echo e(Str::limit(@$course->title, 25)); ?></a>
                            </h4>
                            <span class="module-time d-block mb-6">
                                <?php echo e($course->lessons->count()); ?>

                                <?php echo e(___('frontend.Lesson')); ?>,
                                <?php echo e(minutes_to_hours(@$course->course_duration)); ?>

                            </span>
                            <span class="module-count text-tertiary d-block border-0 p-0 m-0">
                                <?php echo e($course->quizzes->count()); ?>

                                <?php echo e(___('course.Quizzes')); ?> <?php echo e(___('student.&')); ?>

                                <?php echo e($course->assignments->count()); ?> <?php echo e(___('course.Assignments')); ?></span>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                
                <div class="col-lg-3 col-md-6 col-sm-6 m-auto">
                    <div class="not-data-found text-center pt-50 pb-50">
                        <img src="<?php echo e(@showImage(setting('empty_table'), 'backend/assets/images/no-data.png')); ?>"
                            alt="img" class="w-100 mb-20">
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!--  pagination start -->
    <?php echo @$data['courses']->links('frontend.partials.pagination-count'); ?>

    <!--  pagination end -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('organization::panel.organization.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/Modules/Organization/Resources/views/panel/organization/course/my_courses.blade.php ENDPATH**/ ?>