@extends('backend.master')
@section('title')
    {{ @$data['title'] }}
@endsection
@section('content')
    <div class="page-content">

        {{-- breadecrumb Area S t a r t --}}
        @include('backend.ui-components.breadcrumb', [
            'title' => @$data['title'],
            'routes' => [
                route('dashboard') => ___('common.Dashboard'),
                route('career.index') => 'Careers',
                '#' => @$data['title'],
            ],
            'buttons' => 0,
        ])
        {{-- breadecrumb Area E n d --}}

        <!--  category edit start -->
        <div class="card ot-card">

            <div class="card-body">
                <form action="{{ route('career.update', $data['career']->id) }}" enctype="multipart/form-data" method="post">
                    @csrf
                    @method('PUT')
                    {{-- Style Two --}}
                    <div class="row mb-3">
                        <div class="col-lg-12">
                            <div class="row">

                                <div class="col-xl-6 col-md-6 mb-3">
                                    <label for="name" class="form-label ">{{ ___('common.Name') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('title') is-invalid @enderror" name="name"
                                        id="name" placeholder="{{ ___('placeholder.Enter Name') }}"
                                        value="{{ @$data['career']->name }}">
                                    @error('name')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-xl-6 col-md-6 mb-3">
                                    <label for="title" class="form-label ">{{ ___('common.Title') }} <span
                                            class="fillable">*</span></label>
                                    <input class="form-control ot-input @error('title') is-invalid @enderror" name="title"
                                        list="datalistOptions" id="title"
                                        placeholder="{{ ___('placeholder.Enter Title') }}"
                                        value="{{ @$data['career']->title }}">
                                    @error('title')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-xl-6 col-md-6 mb-3 custom-height">
                                    <label for="status" class="form-label ">Overview<span
                                            class="fillable">*</span></label>
                                    <textarea id="overview" name="overview" class="ckeditor-editor @error('overview') is-invalid @enderror">{!! @$data['career']->overview ?? old('overview') !!}</textarea>
                                    @error('overview')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-xl-6 col-md-6">
                                    <label for="icon" class="form-label ">Image
                                        <span class="fillable">*</span>
                                    </label>
                                    <div @if (@$data['career']->imageDetail) data-val="{{ showImage(@$data['career']->imageDetail->original) }}" @endif
                                        data-name="image" class="file @error('image') is-invalid @enderror"
                                        data-height="200px"></div>
                                    <small
                                        class="text-muted">{{ ___('placeholder.NB : Image will not more than 1mb') }}</small>
                                    @error('image')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-xl-12 col-md-6 mb-3 custom-height">
                                    <label for="eligibility" class="form-label ">Eligibility</label>
                                    <textarea id="eligibility" rows="4" cols="10" name="eligibility"
                                        class="ckeditor-editor @error('eligibility') is-invalid @enderror">{!! @$data['career']->eligibility ?? old('eligibility') !!}</textarea>
                                    @error('eligibility')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-xl-12 col-md-6 mb-3 custom-height">
                                    <label for="job_roles" class="form-label ">Types of Job Roles</label>
                                    <textarea id="job_roles" rows="4" cols="10" name="job_roles"
                                        class="ckeditor-editor @error('job_roles') is-invalid @enderror">{!! @$data['career']->job_roles ?? old('job_roles') !!}</textarea>
                                    @error('job_roles')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-xl-12 col-md-6 mb-3 custom-height">
                                    <label for="salary" class="form-label ">Pay Scale/Salary</label>
                                    <textarea id="salary" rows="4" cols="10" name="salary"
                                        class="ckeditor-editor @error('salary') is-invalid @enderror">{!! @$data['career']->salary ?? old('salary') !!}</textarea>
                                    @error('salary')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-xl-12 col-md-6 mb-3 custom-height">
                                    <label for="career_opportunity" class="form-label ">Career Opportunity</label>
                                    <textarea id="career_opportunity" rows="4" cols="10" name="career_opportunity"
                                        class="ckeditor-editor @error('career_opportunity') is-invalid @enderror">{!! @$data['career']->career_opportunity ?? old('career_opportunity') !!}</textarea>
                                    @error('career_opportunity')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                                <div class="col-xl-12 col-md-6 mb-3 custom-height">
                                    <label for="top_colleges" class="form-label ">Top Colleges</label>
                                    <textarea id="top_colleges" rows="4" cols="10" name="top_colleges"
                                        class="ckeditor-editor @error('top_colleges') is-invalid @enderror">{!! @$data['career']->top_colleges ?? old('top_colleges') !!}</textarea>
                                    @error('top_colleges')
                                        <div id="validationServer04Feedback" class="invalid-feedback">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>

                            </div>
                        </div>

                        <div class="col-lg-12 mt-3">
                            <div class="text-left">
                                <button class="btn btn-lg ot-btn-primary" type="submit">
                                    </span>{{ @$data['button'] }}</button>
                            </div>
                        </div>
                    </div>
            </div>
        </div>

        <!--  category edit end -->
    </div>
@endsection
