<?php

namespace Modules\CMS\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSubscriptionRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|max:255',
            'price' => 'required|numeric',
            'duration_type' => 'required|string',
            'duration' => 'required|numeric',
            'status_id' => 'required|max:9|numeric|exists:statuses,id',

        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [
            'name.required' => ___('validation.Name is required.'),
            'name.max' => ___('validation.Name may not be greater than 255 characters.'),
            'price.required' => ___('validation.Price is required.'),
            'price.numeric' => ___('validation.Price must be a amount.'),
            'duration_type.required' => ___('validation.Rating is required.'),
            'duration.numeric' => ___('validation.duration must be a number.'),
            'duration.required' => ___('validation.duration is required.'),
            'status_id.required' => ___('validation.Status is required.'),
            'status_id.max' => ___('validation.Status may not be greater than 9 characters.'),
            'status_id.numeric' => ___('validation.Status must be a number.'),
            'status_id.exists' => ___('validation.Status not found.'),


        ];
    }
}
