<?php

namespace Modules\CMS\Repositories;

use App\Traits\ApiReturnFormatTrait;
use App\Traits\FileUploadTrait;
use Illuminate\Support\Facades\DB;
use Modules\CMS\Entities\Subscription;
use Modules\CMS\Interfaces\SubscriptionInterface;

class SubscriptionRepository implements SubscriptionInterface
{
    use ApiReturnFormatTrait, FileUploadTrait;

    private $model;

    public function __construct(Subscription $subscription)
    {
        $this->model = $subscription;
    }

    public function model()
    {
        try {
            return $this->model;

        } catch (\Throwable $th) {

            return false;
        }

    }

    public function store($request)
    {
        DB::beginTransaction();
        try {

            if (env('APP_DEMO')) {
                return $this->responseWithError(___('alert.you_can_not_change_in_demo_mode'));
            }

            $subscription = $this->model;
            $subscription->name = $request->name;
            $subscription->designation = $request->designation;
            $subscription->rating = $request->rating;
            $subscription->content = $request->content;
            $subscription->status_id = $request->status_id;
            $subscription->save();

            if ($request->hasFile('image_id')) {
                $upload = $this->uploadFile($request->image_id, 'cms/subscriptions/subscription', [], '', 'image'); // upload file and resize image 35x35
                if ($upload['status']) {
                    $subscription->image_id = $upload['upload_id'];
                } else {
                    return $this->responseWithError($upload['message'], [], 400);
                }
            }
            $subscription->save();
            DB::commit();
            return $this->responseWithSuccess(___('alert.Subscription store successfully.'));
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->responseWithError($th->getMessage(), [], 400);
        }
    }

    public function update($request, $id)
    {
        DB::beginTransaction();
        try {

            if (env('APP_DEMO')) {
                return $this->responseWithError(___('alert.you_can_not_change_in_demo_mode'));
            }

            $subscription = $this->model->find($id);
            if (!$subscription) {
                return $this->responseWithError(___('alert.subscription_not_found'), [], 400);
            }
            $subscription->name = $request->name;
            $subscription->designation = $request->designation;
            $subscription->rating = $request->rating;
            $subscription->content = $request->content;
            $subscription->status_id = $request->status_id;
            $subscription->save();

            if ($request->hasFile('image_id')) {
                $upload = $this->uploadFile($request->image_id, 'cms/subscriptions/subscription', [], @$subscription->image_id, 'image'); // upload file and resize image 35x35
                if ($upload['status']) {
                    $subscription->image_id = $upload['upload_id'];
                } else {
                    return $this->responseWithError($upload['message'], [], 400);
                }
            }
            $subscription->save();
            DB::commit();
            return $this->responseWithSuccess(___('alert.Subscription updated successfully.'));
        } catch (\Throwable $th) {
            DB::rollBack();
            return $this->responseWithError($th->getMessage(), [], 400);
        }
    }

    public function destroy($id)
    {
        try {

            if (env('APP_DEMO')) {
                return $this->responseWithError(___('alert.you_can_not_change_in_demo_mode'));
            }
            
            $subscription = $this->model->find($id);
            $upload = $this->deleteFile($subscription->image_id, 'delete'); // delete file from storage
            if (!$upload['status']) {
                return $this->responseWithError($upload['message'], [], 400); // return error response
            }
            $subscription->delete();
            return $this->responseWithSuccess(___('alert.Subscription deleted successfully.')); // return success response
        } catch (\Throwable $th) {
            return $this->responseWithError($th->getMessage(), [], 400); // return error response
        }
    }
}
