@extends('backend.master')
@section('title')
{{ @$data['title'] }}
@endsection
@section('content')
<div class="page-content">

    {{-- breadecrumb Area S t a r t --}}
    @include('backend.ui-components.breadcrumb', [
    'title' => @$data['title'],
    'routes' => [
    route('dashboard') => ___('common.Dashboard'),
    route('admin.subscription.index') => ___('common.subscription List'),
    '#' => @$data['title'],
    ],
    'buttons' => 0,
    ])
    {{-- breadecrumb Area E n d --}}

    <!--  category create start -->
    <div class="card ot-card">

        <div class="card-body">
            <form action="{{ route('admin.subscription.update', $data['subscription']->id ) }}" enctype="multipart/form-data" method="post">
                @csrf

                {{-- Style Two --}}
                <div class="row mb-3 row mb-3 d-flex justify-content-center">
                    <div class="col-lg-12">
                        <div class="row">
                            <div class="col-xl-6 col-md-6 mb-3">
                                <label for="name" class="form-label ">{{ ___('common.name') }} <span class="fillable">*</span></label>
                                <input class="form-control ot-input @error('name') is-invalid @enderror" name="name" list="datalistOptions" id="name" value="{{  @$data['subscription']->name }}" placeholder="{{ ___('placeholder.Enter Name') }}">
                                @error('name')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="col-xl-6 col-md-6 mb-3">
                                <label for="status" class="form-label ">{{ ___('common.Status') }}
                                    <span class="fillable">*</span></label>
                                <select class="form-select ot-input select2 @error('status_id') is-invalid @enderror" id="status" required name="status_id">
                                    <option value="1" {{ @$data['subscription']->status_id == 1 ? 'selected' : '' }}>{{ ___('common.Active') }}</option>
                                    <option value="2" {{ @$data['subscription']->status_id == 2 ? 'selected' : '' }}>{{ ___('common.Inactive') }}</option>
                                </select>
                                @error('status_id')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="col-xl-6 col-md-6 mb-3">
                                <label for="rating" class="form-label ">{{ ___('common.Price') }}
                                    <span class="fillable">*</span></label>
                                <input class="form-control ot-input @error('price') is-invalid @enderror" name="price" list="datalistOptions" id="price" value="{{  @$data['subscription']->price }}" placeholder="{{ ___('placeholder.Enter Price') }}">
                                @error('price')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>



                            <div class="col-xl-6 col-md-6 mb-3 row">
                                <div class="col-xl-6 col-md-6 mb-3">
                                    <label for="status" class="form-label ">{{ ___('common.Duration') }}
                                        <span class="fillable">*</span></label>
                                    <input type="number" class="form-control ot-input @error('duration') is-invalid @enderror" value="{{  @$data['subscription']->duration }}" name="duration" list="datalistOptions" id="duration" placeholder="{{ ___('placeholder.Enter Duration') }}">
                                    @error('duration')
                                    <div id="validationServer04Feedback" class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                                <div class="col-xl-6 col-md-6 mb-3">
                                    <label for="duration_type" class="form-label ">{{ ___('common.duration_type') }}
                                        <span class="fillable">*</span></label>
                                    <select class="form-select ot-input select2 @error('duration_type') is-invalid @enderror" id="duration_type" required name="duration_type">
                                        <option value="month" {{ @$data['subscription']->duration_type == 'month' ? 'selected' : '' }}>{{ ___('common.Month') }}</option>
                                        <option value="year" {{ @$data['subscription']->duration_type == 'year' ? 'selected' : '' }}>{{ ___('common.Year') }}</option>
                                    </select>
                                    @error('duration_type')
                                    <div id="validationServer04Feedback" class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-xl-6 col-md-6 mb-3">
                                <label for="Features" class="form-label ">{{ ___('common.Features') }} <span class="fillable">*</span></label>
                                <button type="button" id="add-feature" style="margin-left:20px" class="btn btn-success mt-2">+</button>
                                <div id="features-container">
                                    @foreach($data['subscription']->features as $feature)
                                    <div class="form-group d-flex align-items-center mt-5">
                                        <input type="text" class="form-control mr-5" id="feature_{{ $feature->id }}" name="features[]" value="{{  $feature->name }}" required placeholder="Enter Name">
                                        <input type="text" class="form-control mr-5" id="value_{{ $feature->id }}" style="margin-left:20px" name="values[]" value="{{  $feature->value }}" required placeholder="Enter Value">
                                        <button type="button" class="btn btn-danger   remove-feature" style="margin-left:20px">-</button>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>


                    </div>
                </div>

                <div class="col-lg-12 mt-3">
                    <div class="text-end">
                        <button class="btn btn-lg ot-btn-primary" type="submit">
                            {{ @$data['button'] }}
                        </button>
                    </div>
                </div>
        </div>
    </div>
</div>

<!--  category create end -->
</div>
@endsection
@push('script')
<script>
    $('#add-feature').click(function() {
        const featureCount = $('#features-container .form-group').length;
        const featureDiv = `
                    <div class="form-group d-flex align-items-center mt-5 ">
                    <input type="text" class="form-control mr-5" id="feature_${featureCount}" name="features[]" required placeholder="Enter Name">
                    <input type="text" class="form-control ml-5" style="margin-left:20px" id="value_${featureCount}" name="values[]" required placeholder="Enter Value">
                        <button type="button" class="btn btn-danger  remove-feature" style="margin-left:20px">-</button>
                    </div>
                `;
        $('#features-container').append(featureDiv);
    });

    $('#features-container').on('click', '.remove-feature', function() {
        $(this).closest('.form-group').remove();
    });
</script>
@endpush