<?php

namespace Modules\Course\Http\Controllers;

use App\Models\Inquiry;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Course\Interfaces\CourseInterface;
use Modules\Course\Interfaces\ReviewInterface;

class ReviewController extends Controller
{

    protected $review;
    protected $course;

    public function __construct(
        ReviewInterface $reviewInterface,
        CourseInterface $courseInterface) {
        $this->review = $reviewInterface;
        $this->course = $courseInterface;
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {
        try {
            $data['courses'] = $this->course->model()
                ->search($request)
                ->paginate($request->show ?? 10); // data
            $data['title'] = ___('course.Review List'); // title
            return view('course::review.index', compact('data')); // view
        } catch (\Throwable $th) {

            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function inquiries(Request $request)
    {
        // try {
        if ($request->search) {
            $search = $request->search;
            $data['inquiries'] = Inquiry::where('name', 'like', '%' . $search . '%')->orWhere('email', 'like', '%' . $search . '%')->orWhere('phone', 'like', '%' . $search . '%')->latest()->paginate(10);
        } else {
            $data['inquiries'] = Inquiry::latest()->paginate(10);
        }
        $data['title'] = ___('organization.Organization Inquires List'); // title
        return view('course::inquires.index', compact('data')); // view
        // } catch (\Throwable $th) {
        //     return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        // }
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('course::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('course::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('course::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
