<?php

namespace Modules\Organization\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Course\Entities\Course;

class CourseCallbackRequest extends Model
{
    use HasFactory;

    protected $table = 'course_callback_requests';

    protected $fillable = [
        'course_id',
        'name',
        'phone'
    ];

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }
}