<?php

namespace Modules\Organization\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ReviewRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "title" => "required|max:500",
            "description" => "required|max:50000",
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [
            'title.required' => ___('validation.title are required'),
            'title.max' => ___('validation.title must be less than 500 characters'),
            'description.required' => ___('validation.description are required'),
            'description.max' => ___('validation.description must be less than 500 characters'),
        ];
    }
}
