@extends('organization::panel.organization.layouts.master')
@section('title')
{{ @$data['title'] }}
@endsection


@section('content')
<div class="page-content">

    {{-- breadecrumb Area S t a r t --}}
    @include('backend.ui-components.breadcrumb', [
    'title' => @$data['title'],
    'routes' => [
    route('dashboard') => ___('common.Dashboard'),
    '#' => @$data['title'],
    ],

    'buttons' => 1,
    ])
    {{-- breadecrumb Area E n d --}}

    <!--  table content start -->
    <div class="table-content table-basic ecommerce-components product-list">
        <div class="card">
            <div class="card-body">
                <!--  toolbar table start  -->
                <div
                    class="table-toolbar d-flex flex-wrap gap-2 flex-column flex-xl-row justify-content-center justify-content-xxl-between align-content-center pb-3">
                    <form action="" method="get">
                        <div class="align-self-center">
                            <div
                                class="d-flex flex-wrap gap-2 flex-column flex-lg-row justify-content-center align-content-center">
                                <!-- show per page -->
                                @include('backend.ui-components.per-page')
                                <!-- show per page end -->

                                <div class="align-self-center d-flex gap-2">
                                    <!-- search start -->
                                    <div class="align-self-center">
                                        <div class="search-box d-flex">
                                            <input class="form-control" placeholder="{{ ___('common.search') }}"
                                                name="search" value="{{ @request()->search }}" />
                                            <span class="icon"><i class="fa-solid fa-magnifying-glass"></i></span>
                                        </div>
                                    </div>
                                    <!-- search end -->


                                    <!-- dropdown action -->
                                    <div class="align-self-center">

                                        <button type="submit" class="btn-add btn btn-primary">
                                            <span class="icon">{{ ___('common.Filter') }}</span>
                                        </button>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>


                    <!-- add btn start -->

                    <div class="align-self-center d-flex gap-2">
                        <!-- add btn -->
                        <div class="align-self-center">
                            <!-- <a href="{{ route('organization.slider.create') }}" role="button" class="btn-primary btn"
                                data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Add">
                                <span><i class="fa-solid fa-plus"></i> </span>
                                <span class="d-none d-xl-inline">{{ ___('common.add') }}</span>
                            </a> -->
                        </div>
                    </div>

                    <!-- add btn end -->
                </div>
                <!--toolbar table end -->
                <!--  table start -->
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead class="thead">
                            <!-- start table header from ui-helper function -->

                            @if (auth()->user()->role_id == \App\Enums\Role::ADMIN)
                            {{ table_header('', 
                            [
                            'ID',
                            'Organization',
                            'name',
                            'Email',
                            'Phone',
                            'Status',
                            'course',
                            'Created_at'
                            ]
                            ) }}
                            @else

                            {{ table_header('', 
                            [
                            'ID',
                            'name',
                            'Email',
                            'Phone',
                            'Status',
                            'course',
                            'Created_at'
                            ]
                            ) }}
                            @endif


                            <!-- end table header -->
                        </thead>
                        <tbody class="tbody">

                            @forelse ($data['inquiries'] as $key => $slider)
                            <tr>
                                <td>{{ @$slider->id }}</td>
                                @if (auth()->user()->role_id == \App\Enums\Role::ADMIN)
                                <td>{{ @$slider->user->name }}</td>
                                @endif
                                <td>{{ Str::limit(@$slider->name, 20) }}</td>
                                <td>{{ Str::limit(@$slider->email, 20) }}</td>
                                <td>{{ Str::limit(@$slider->phone, 20) }}</td>
                                <td>
                                    {{ statusBackend(@$slider->status->class, $slider->status->name) }}
                                </td>
                                <td>{{ @$slider->course->title }}</td>
                                <td class="create-date">{{ showDate(@$slider->created_at) }}</td>

                                <!-- <td class="action">
                                    <a href="{{ route('organization.slider.edit', $slider->id) }}" class="btn btn-primary btn-sm">Edit</a>
                                    <form action="{{ route('organization.slider.destroy', $slider->id) }}" method="POST" style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this item?');">Delete</button>
                                    </form>


                                </td> -->
                            </tr>
                            @empty
                            <!-- empty table -->
                            @include('backend.ui-components.empty_table', [
                            'colspan' => '8',
                            'message' => ___(
                            'message.Please add a new entity or manage the data table to see the content here'),
                            ])
                            <!-- empty table -->
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <!--  table end -->
                <!--  pagination start -->
                @include('backend.ui-components.pagination', ['data' => $data['inquiries']])
                <!--  pagination end -->
            </div>
        </div>
    </div>
    <!--  table content end -->
</div>
@endsection
@push('script')
@include('backend.partials.delete-ajax')
@endpush